/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util.sm.sm3;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM3 {
    public static String encrypt(String paramStr) {
        String resultHexString = "";
        try {
            byte[] srcData = paramStr.getBytes("UTF-8");
            byte[] resultHash = SM3.hash(srcData);
            resultHexString = ByteUtils.toHexString((byte[])resultHash);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultHexString;
    }

    public static byte[] hash(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static String encryptPlus(String paramStr, String key) {
        String resultHexString = "";
        try {
            byte[] srcData = paramStr.getBytes("UTF-8");
            byte[] resultHash = SM3.hmac(srcData, key.getBytes("UTF-8"));
            resultHexString = ByteUtils.toHexString((byte[])resultHash);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultHexString;
    }

    public static byte[] hmac(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static boolean verify(String srcStr, String sm3HexString) {
        boolean flag = false;
        try {
            byte[] srcData = srcStr.getBytes("UTF-8");
            byte[] sm3Hash = ByteUtils.fromHexString((String)sm3HexString);
            byte[] newHash = SM3.hash(srcData);
            if (Arrays.equals(newHash, sm3Hash)) {
                flag = true;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static void main(String[] args) {
        String str = "{\"test\":\"001\"}";
        String key = "key";
        String hex = SM3.encryptPlus(str, key);
        System.out.println("\u53c2\u6570:" + str);
        System.out.println("\u5bc6\u6587:" + hex);
    }
}

