/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlUtils {
    public static JSONObject xmlToJson(String xml) {
        return XmlUtils.elementToJson(XmlUtils.strToDocument(xml).getRootElement());
    }

    public static boolean isXml(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = (String)obj;
        if (str.length() < 10) {
            return false;
        }
        String sub = str.substring(0, 5);
        return "<?xml".equals(sub);
    }

    public static Document jsonToXml(JSONObject json) {
        String xml = XmlUtils.jsonToXml(json.toString());
        return XmlUtils.strToDocument(xml);
    }

    public static String jsonToXml(String json) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            JSONObject jObj = JSON.parseObject((String)json);
            XmlUtils.jsonToXmlStr(jObj, buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static Document strToDocument(String xml) {
        try {
            return DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            return null;
        }
    }

    private static JSONObject elementToJson(Element node) {
        JSONObject result = new JSONObject();
        List listAttr = node.attributes();
        for (Attribute attr : listAttr) {
            result.put(attr.getName(), (Object)attr.getValue());
        }
        List listElement = node.elements();
        if (!listElement.isEmpty()) {
            for (Element e : listElement) {
                if (e.attributes().isEmpty() && e.elements().isEmpty()) {
                    result.put(e.getName(), (Object)e.getTextTrim());
                    continue;
                }
                if (!result.containsKey((Object)e.getName())) {
                    result.put(e.getName(), (Object)new JSONArray());
                }
                ((JSONArray)result.get((Object)e.getName())).add((Object)XmlUtils.elementToJson(e));
            }
        }
        return result;
    }

    private static void jsonToXmlStr(JSONObject jObj, StringBuffer buffer) {
        Set se = jObj.entrySet();
        for (Map.Entry en : se) {
            if ("com.alibaba.fastjson.JSONObject".equals(en.getValue().getClass().getName())) {
                buffer.append("<").append((String)en.getKey()).append(">");
                JSONObject jo = jObj.getJSONObject((String)en.getKey());
                XmlUtils.jsonToXmlStr(jo, buffer);
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if ("com.alibaba.fastjson.JSONArray".equals(en.getValue().getClass().getName())) {
                JSONArray jarray = jObj.getJSONArray((String)en.getKey());
                for (int i = 0; i < jarray.size(); ++i) {
                    buffer.append("<").append((String)en.getKey()).append(">");
                    Object o = jarray.get(i);
                    if ("java.lang.String".equals(o.getClass().getName())) {
                        buffer.append(o);
                    } else if ("java.lang.Integer".equals(o.getClass().getName())) {
                        buffer.append(o);
                    } else if ("java.lang.Float".equals(o.getClass().getName())) {
                        buffer.append(o);
                    } else if ("java.lang.Double".equals(o.getClass().getName())) {
                        buffer.append(o);
                    } else if ("java.lang.Long".equals(o.getClass().getName())) {
                        buffer.append(o);
                    } else if ("java.lang.Boolean".equals(o.getClass().getName())) {
                        buffer.append(o);
                    } else {
                        JSONObject jsonobject = jarray.getJSONObject(i);
                        XmlUtils.jsonToXmlStr(jsonobject, buffer);
                    }
                    buffer.append("</").append((String)en.getKey()).append(">");
                }
                continue;
            }
            if ("java.lang.String".equals(en.getValue().getClass().getName())) {
                buffer.append("<").append((String)en.getKey()).append(">").append(en.getValue());
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if ("java.lang.Integer".equals(en.getValue().getClass().getName())) {
                buffer.append("<").append((String)en.getKey()).append(">").append(en.getValue().toString());
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if ("java.lang.Float".equals(en.getValue().getClass().getName())) {
                buffer.append("<").append((String)en.getKey()).append(">").append(en.getValue().toString());
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if ("java.lang.Double".equals(en.getValue().getClass().getName())) {
                buffer.append("<").append((String)en.getKey()).append(">").append(en.getValue().toString());
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if ("java.lang.Long".equals(en.getValue().getClass().getName())) {
                buffer.append("<").append((String)en.getKey()).append(">").append(en.getValue().toString());
                buffer.append("</").append((String)en.getKey()).append(">");
                continue;
            }
            if (!"java.lang.Boolean".equals(en.getValue().getClass().getName())) continue;
            buffer.append("<").append((String)en.getKey()).append(">").append(en.getValue().toString());
            buffer.append("</").append((String)en.getKey()).append(">");
        }
    }
}

