/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AESUtil.class);

    public static String encrypt(String content, String key) {
        return AESUtil.base64ToString(AESUtil.AES_ECB_Encrypt(content.getBytes(), key.getBytes()));
    }

    public static String decrypt(String content, String key) {
        try {
            byte[] base64 = AESUtil.stringToBase64(content);
            byte[] bytes = AESUtil.AES_ECB_Decrypt(base64, key.getBytes());
            String result = new String(bytes);
            return result.replaceAll("\"", "");
        }
        catch (Exception e) {
            LOG.error("AES\u89e3\u5bc6\u5931\u8d25\uff0ccontent\uff1a\u3010{}\u3011", (Object)content, (Object)e);
            return null;
        }
    }

    private static byte[] AES_ECB_Encrypt(byte[] content, byte[] keyBytes) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            LOG.error("AES\u52a0\u5bc6\u5931\u8d25\uff0ccontent\uff1a\u3010{}\u3011", (Object)AESUtil.base64ToString(content), (Object)e);
            return null;
        }
    }

    private static byte[] AES_ECB_Decrypt(byte[] content, byte[] keyBytes) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            LOG.error("AES\u52a0\u5bc6\u5931\u8d25\uff0ccontent\uff1a\u3010{}\u3011", (Object)AESUtil.base64ToString(content), (Object)e);
            return null;
        }
    }

    public static byte[] stringToBase64(String key) {
        return Base64.decodeBase64((byte[])key.getBytes());
    }

    public static String base64ToString(byte[] key) {
        return new Base64().encodeToString(key);
    }

    public static void main(String[] args) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(128);
        byte[] encoded = keyGenerator.generateKey().getEncoded();
        String s = AESUtil.base64ToString(encoded);
        System.out.println(encoded);
        String content = "hainiu aes";
        String end = AESUtil.base64ToString(AESUtil.AES_ECB_Encrypt(content.getBytes(), encoded));
        System.out.println("\u52a0\u5bc6\uff1a" + end);
    }
}

