/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.cache.impl;

import com.manatee.common.util.tool.cache.GlobalPruneTimer;
import com.manatee.common.util.tool.cache.impl.AbstractCache;
import com.manatee.common.util.tool.cache.impl.CacheObj;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;

public class TimedCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout) {
        this(timeout, new HashMap());
    }

    public TimedCache(long timeout, Map<K, CacheObj<K, V>> map) {
        this.capacity = 0;
        this.timeout = timeout;
        this.cacheMap = map;
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }

    public void schedulePrune(long delay) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(this::prune, delay);
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

