/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.util.ArrayUtils;
import com.manatee.common.util.DateUtils;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.tool.core.text.StrFormatter;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class StrUtils
extends StringUtils {
    public static int numStr(String exp, String str) {
        int len = exp.length();
        String newExp = exp.replace(str, "");
        int size = len - newExp.length();
        return size / str.length();
    }

    public static Object parseJson(Object value) {
        if (value instanceof String) {
            String valueStr = String.valueOf(value);
            if (valueStr.indexOf("##string##") != -1) {
                value = valueStr.replace("##string##", "");
            } else if (valueStr.startsWith("{") && valueStr.endsWith("}")) {
                value = JSON.parseObject((String)valueStr, (Feature[])new Feature[]{Feature.OrderedField});
            } else if (valueStr.startsWith("[") && valueStr.endsWith("]")) {
                value = JSONArray.parse((String)valueStr, (Feature[])new Feature[]{Feature.OrderedField});
            }
        }
        return value;
    }

    public static String leftPad(int value, int size, char padChar) {
        String str = String.valueOf(value);
        str = StrUtils.leftPad((String)str, (int)size, (char)padChar);
        return str;
    }

    public static String rightPad(int value, int size, char padChar) {
        String str = String.valueOf(value);
        str = StrUtils.rightPad((String)str, (int)size, (char)padChar);
        return str;
    }

    public static String GetString(Object as_str) {
        if (as_str == null) {
            return "";
        }
        if ("null".equals(as_str)) {
            return "";
        }
        return "undefined".equals(as_str.toString().toLowerCase()) ? "" : as_str + "";
    }

    public static String GetNum(Object as_str) {
        String val = StrUtils.GetString(as_str);
        if (val.equals("")) {
            return "0";
        }
        return val;
    }

    public static boolean isEmptyOrNull(Object as_str) {
        return "".equals(StrUtils.GetString(as_str).trim());
    }

    public static boolean isNullOrEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static String addQuote(String str) {
        if (!"NULL".equalsIgnoreCase(str)) {
            str = "'" + StrUtils.encodeSingleQuotedString(str) + "'";
        }
        return str;
    }

    public static String leftQuote(String str) {
        str = "'" + StrUtils.encodeSingleQuotedString(str);
        return str;
    }

    public static String rightQuote(String str) {
        str = StrUtils.encodeSingleQuotedString(str) + "'";
        return str;
    }

    public static String encodeSingleQuotedString(String str) {
        if (StrUtils.isNotEmpty((String)str)) {
            StringBuffer sb = new StringBuffer(64);
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return str;
    }

    public static String formatDouble(double value) {
        String str = "0.0";
        if (value != 0.0) {
            DecimalFormat nf = new DecimalFormat("#.##");
            nf.setParseIntegerOnly(false);
            nf.setDecimalSeparatorAlwaysShown(false);
            str = nf.format(value);
        }
        return str;
    }

    public static String formatDouble(double value, int digitNum) {
        String str = "0.0";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < digitNum; ++i) {
            sb.append("0");
        }
        DecimalFormat nf = new DecimalFormat("#." + sb.toString());
        nf.setParseIntegerOnly(false);
        nf.setDecimalSeparatorAlwaysShown(false);
        str = nf.format(value);
        if (StrUtils.isEmpty((String)str.split("\\.")[0])) {
            str = "0" + str;
        }
        return str;
    }

    public static String[] tokenize(String str, String delimiter) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(str, delimiter);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (!StrUtils.isNotEmpty((String)s)) continue;
            v.add(s.trim());
        }
        String[] pro = new String[v.size()];
        for (int i = 0; i < pro.length; ++i) {
            pro[i] = (String)v.get(i);
        }
        return pro;
    }

    public static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer(64);
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            StrUtils.byte2hex(block[i], buf);
        }
        return buf.toString();
    }

    public static String addFlagQuote(String str) {
        StringBuffer sbFlag = new StringBuffer(16);
        String[] flags = StrUtils.tokenize(str, ",");
        int count = flags.length;
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                sbFlag.append(",");
            }
            sbFlag.append("'" + flags[i] + "'");
        }
        return sbFlag.toString();
    }

    public static String getData(String resouce, String label) {
        String result = "";
        String labelB = "";
        String labelE = "";
        int site1 = 0;
        int site2 = 0;
        if (resouce == null || label == null) {
            return result;
        }
        resouce = resouce.trim();
        labelB = "<" + label + ">";
        labelE = "</" + label + ">";
        site1 = resouce.indexOf(labelB) + labelB.length();
        site2 = resouce.indexOf(labelE);
        if (site1 < 0 || site2 < 0) {
            return "";
        }
        result = resouce.substring(site1, site2);
        return result;
    }

    public static String convertToGB(String str) {
        String result = str;
        String charCodeOld = "UTF-8";
        String charCodeNew = "GBK";
        if (StrUtils.isNotEmpty((String)result)) {
            try {
                byte[] bytes = result.getBytes(charCodeOld);
                result = new String(bytes, charCodeNew);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String convertToISO(String str) {
        String result = str;
        String charCodeOld = "GBK";
        String charCodeNew = "8859_1";
        if (StrUtils.isNotEmpty((String)result)) {
            try {
                byte[] bytes = result.getBytes(charCodeOld);
                result = new String(bytes, charCodeNew);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String fomatHtmlText(String reCeiv) {
        String cMesg = "";
        String sMesg = "";
        for (int ii = 0; ii < reCeiv.length(); ++ii) {
            cMesg = reCeiv.substring(ii, ii + 1);
            sMesg = "\n".compareTo(cMesg) == 0 ? sMesg + "<br>" : (" ".compareTo(cMesg) == 0 ? sMesg + "&nbsp" : sMesg + cMesg);
        }
        return sMesg;
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String getFormatDate(String s) {
        String s_date = "";
        s_date = s.trim().length() == 14 ? s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s.substring(6, 8) : s;
        return s_date;
    }

    public static String getPriorDay(int offset) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Calendar theday = Calendar.getInstance();
        theday.add(5, offset);
        df.applyPattern("yyyyMMdd");
        return df.format(theday.getTime());
    }

    public static String trim(String s) {
        if (s == null || "".equalsIgnoreCase(s) || "null".equalsIgnoreCase(s)) {
            return "";
        }
        return s.trim();
    }

    public static String getStrSysYear() {
        Calendar getTime = Calendar.getInstance(Locale.CHINA);
        return Integer.toString(getTime.get(1));
    }

    public static int getIntSysYear() {
        Calendar getTime = Calendar.getInstance(Locale.CHINA);
        return getTime.get(1);
    }

    public static int getIntSysMonth() {
        Calendar getTime = Calendar.getInstance(Locale.CHINA);
        return getTime.get(2) + 1;
    }

    public static String getStrSysDay() {
        Calendar getTime = Calendar.getInstance(Locale.CHINA);
        return Integer.toString(getTime.get(5));
    }

    public static int getIntSysDay() {
        Calendar getTime = Calendar.getInstance(Locale.CHINA);
        return getTime.get(5);
    }

    public static String getFileModifyTime(String fileName) {
        File fn = new File(fileName);
        Long.toString(fn.lastModified());
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar theday = Calendar.getInstance();
        theday.setTimeInMillis(fn.lastModified());
        df.applyPattern("yyyy/MM/dd HH:mm:ss");
        return df.format(theday.getTime());
    }

    public static String getLikeString(String colName, String colValue) {
        return colName + " Like '%" + colValue + "%'";
    }

    public static String getUpperInteger(int in) {
        String out = "";
        int tmp = in;
        do {
            int tmp1 = tmp % 10;
            switch (tmp1) {
                case 1: {
                    out = "\u4e00" + out;
                    break;
                }
                case 2: {
                    out = "\u4e8c" + out;
                    break;
                }
                case 3: {
                    out = "\u4e09" + out;
                    break;
                }
                case 4: {
                    out = "\u56db" + out;
                    break;
                }
                case 5: {
                    out = "\u4e94" + out;
                    break;
                }
                case 6: {
                    out = "\u516d" + out;
                    break;
                }
                case 7: {
                    out = "\u4e03" + out;
                    break;
                }
                case 8: {
                    out = "\u516b" + out;
                    break;
                }
                case 9: {
                    out = "\u4e5d" + out;
                }
            }
        } while ((tmp /= 10) != 0);
        return out;
    }

    public static String changeNullToEmpty(String str) {
        if (StrUtils.isEmpty((String)str)) {
            return "";
        }
        return str;
    }

    public static String convertURL(String URL2) {
        if (StrUtils.isEmpty((String)URL2)) {
            return "";
        }
        return URL2.replace('\\', '/');
    }

    public static String byteToString(byte b) {
        int maskHigh = -16;
        int maskLow = 15;
        byte high = (byte)((b & maskHigh) >> 4);
        byte low = (byte)(b & maskLow);
        StringBuffer buf = new StringBuffer();
        buf.append(StrUtils.findHex(high));
        buf.append(StrUtils.findHex(low));
        return buf.toString();
    }

    private static char findHex(byte b) {
        int t = new Byte(b).intValue();
        int n = t = t < 0 ? t + 16 : t;
        if (t >= 0 && t <= 9) {
            return (char)(t + 48);
        }
        return (char)(t - 10 + 65);
    }

    public static int stringToByte(String in, byte[] b) {
        if (b.length < in.length() / 2) {
            return 0;
        }
        int j = 0;
        StringBuffer buf = new StringBuffer(2);
        int i = 0;
        while (i < in.length()) {
            buf.insert(0, in.charAt(i));
            buf.insert(1, in.charAt(i + 1));
            int t = Integer.parseInt(buf.toString(), 16);
            b[j] = (byte)t;
            ++i;
            buf.delete(0, 2);
            ++i;
            ++j;
        }
        return j;
    }

    public static byte[] hex2Bytes(String hexString) {
        if (hexString == null) {
            return null;
        }
        if (hexString.length() % 2 != 0) {
            hexString = '0' + hexString;
        }
        byte[] result = new byte[hexString.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)Integer.parseInt(hexString.substring(i * 2, (i + 1) * 2), 16);
        }
        return result;
    }

    public static String bytes2Hex(byte[] bytes) {
        StringBuffer result = new StringBuffer("");
        if (bytes == null) {
            return "";
        }
        for (int i = 0; i < bytes.length; ++i) {
            result.append(StrUtils.padding2Head(Integer.toHexString(bytes[i] & 0xFF), '0', 2));
        }
        return result.toString();
    }

    public static String padding2Head(String s, char ch, int destLength) {
        StringBuffer str = null;
        if (destLength < 0) {
            return "";
        }
        if (s == null) {
            str = new StringBuffer();
            for (int i = 0; i < destLength; ++i) {
                str.append(ch);
            }
        } else {
            if (s.length() > destLength) {
                return "";
            }
            str = new StringBuffer();
            for (int i = 0; i < destLength - s.length(); ++i) {
                str.append(ch);
            }
            str.append(s);
        }
        return str.toString();
    }

    public static String subStringCN(String str, int maxLength) {
        int i;
        if (str == null) {
            return str;
        }
        String suffix = "**";
        int suffixLen = suffix.length();
        StringBuffer sbuffer = new StringBuffer();
        char[] chr = str.trim().toCharArray();
        int len = 0;
        for (i = 0; i < chr.length; ++i) {
            if (chr[i] >= '\u00a1') {
                len += 2;
                continue;
            }
            ++len;
        }
        len = 0;
        for (i = 0; i < chr.length; ++i) {
            if (chr[i] >= '\u00a1') {
                if ((len += 2) + suffixLen > maxLength) break;
                sbuffer.append(chr[i]);
                continue;
            }
            if (++len + suffixLen > maxLength) break;
            sbuffer.append(chr[i]);
        }
        sbuffer.append(suffix);
        return sbuffer.toString();
    }

    public static String changeCharset(String str, String oldCharset, String newCharset) {
        if (StrUtils.isNotEmpty((String)str)) {
            try {
                byte[] bs = str.getBytes(oldCharset);
                return new String(bs, newCharset);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static int sum(String text, int len) {
        text = len > 0 ? text.substring(0, len) : text;
        int value = 0;
        Pattern p = Pattern.compile("[^0-9]");
        Matcher m = p.matcher(text);
        String result = m.replaceAll("");
        for (int i = 0; i < result.length(); ++i) {
            value += NumberUtils.parseInt(result.substring(i, i + 1));
        }
        return value;
    }

    public static String parSetName(String fieldName) {
        if (StrUtils.isEmpty((String)fieldName)) {
            return null;
        }
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static void setFieldValue(Object bean, String name, Object value) {
        try {
            Field field = bean.getClass().getDeclaredField(name);
            String fieldSetName = StrUtils.parSetName(field.getName());
            Method fieldSetMet = bean.getClass().getMethod(fieldSetName, field.getType());
            String str = StrUtils.GetString(value);
            if (null != value && !"".equals(value)) {
                String fieldType = field.getType().getSimpleName();
                if ("String".equals(fieldType)) {
                    fieldSetMet.invoke(bean, value);
                } else if ("Date".equals(fieldType)) {
                    Date temp = DateUtils.StrToDate(str, "");
                    fieldSetMet.invoke(bean, temp);
                } else if ("Integer".equals(fieldType) || "int".equals(fieldType)) {
                    Integer intval = NumberUtils.parseInt(str);
                    fieldSetMet.invoke(bean, intval);
                } else if ("Long".equalsIgnoreCase(fieldType)) {
                    Long temp = NumberUtils.parseLong(str);
                    fieldSetMet.invoke(bean, temp);
                } else if ("Double".equalsIgnoreCase(fieldType)) {
                    Double temp = NumberUtils.parseDouble(str);
                    fieldSetMet.invoke(bean, temp);
                } else if ("Boolean".equalsIgnoreCase(fieldType)) {
                    Boolean temp = Boolean.parseBoolean(str);
                    fieldSetMet.invoke(bean, temp);
                } else if ("BigDecimal".equalsIgnoreCase(fieldType)) {
                    BigDecimal temp = BigDecimal.valueOf(NumberUtils.parseDouble(str));
                    fieldSetMet.invoke(bean, temp);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("[s*|t*|r*|n*]");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("[p{P}]", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = ch.length;
        float count = 0.0f;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (Character.isLetterOrDigit(c) || StrUtils.isChinese(c)) continue;
            count += 1.0f;
        }
        float result = count / chLength;
        return (double)result > 0.4;
    }

    public static String removeFourChar(String content, String charsetName) throws UnsupportedEncodingException {
        byte[] conbyte = content.getBytes(charsetName);
        for (int i = 0; i < conbyte.length; ++i) {
            if ((conbyte[i] & 0xF8) != 240) continue;
            for (int j = 0; j < 4; ++j) {
                conbyte[i + j] = 48;
            }
            i += 3;
        }
        content = new String(conbyte, charsetName);
        return content.replaceAll("0000", "");
    }

    public static String replaceSpecialStr(String str) {
        str = str.replaceAll("\\p{Punct}", "");
        return str;
    }

    public static boolean isInvalidCharacter(String str) {
        String newStr = str.replace("-", "");
        Pattern p = Pattern.compile("\\p{Punct}");
        Matcher m = p.matcher(newStr);
        return m.find();
    }

    public static boolean isChinese(String string) {
        char n = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n < '\u4e00' || n >= '\u9fa5') continue;
            return true;
        }
        return false;
    }

    public static boolean isCNPhone(String phone) {
        Pattern p = Pattern.compile("^1[1-9][0-9]\\d{4,8}$");
        Matcher m = p.matcher(phone);
        return m.matches();
    }

    public static boolean isPhone(String phone) {
        Pattern p = Pattern.compile("\\d{6,}");
        Matcher m = p.matcher(phone);
        return m.matches();
    }

    public static boolean isEmail(String email) {
        Pattern p = Pattern.compile("^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w{2,3}){1,3})$");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        if (StrUtils.isEmpty(str)) {
            return StrUtils.str(str);
        }
        int strLength = str.length();
        if (startInclude > strLength) {
            return StrUtils.str(str);
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return StrUtils.str(str);
        }
        char[] chars = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            chars[i] = i >= startInclude && i < endExclude ? replacedChar : str.charAt(i);
        }
        return new String(chars);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (StrUtils.isBlankChar(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        return !ArrayUtils.isEmpty(params) && !StrUtils.isBlank(template) ? StrFormatter.format(template.toString(), params) : template.toString();
    }

    public static String utf8Str(Object obj) {
        return StrUtils.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtils.str((ByteBuffer)obj, charset);
        }
        return ArrayUtil.isArray(obj) ? ArrayUtil.toString(obj) : obj.toString();
    }

    public static void main(String[] args) {
        System.out.print(StrUtils.replaceSpecialStr("f ad&)sd*ds-_a"));
    }
}

