/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.util.StrUtils;

public class SLEmojiFilter {
    public static boolean containsEmoji(String source) {
        if (StrUtils.isBlank((String)source)) {
            return false;
        }
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!SLEmojiFilter.isEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source, String replacement) {
        if (replacement == null || "".equals(replacement)) {
            replacement = "*";
        }
        if (!SLEmojiFilter.containsEmoji(source = source.replaceAll("[\\ud800\\udc00-\\udbff\\udfff\\ud800-\\udfff]", replacement))) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (SLEmojiFilter.isEmojiCharacter(codePoint)) {
                if (buf == null) {
                    buf = new StringBuilder(source.length());
                }
                buf.append(codePoint);
                continue;
            }
            buf.append("*");
        }
        if (buf == null) {
            return source;
        }
        if (buf.length() == len) {
            buf = null;
            return source;
        }
        return buf.toString();
    }
}

