/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class OperateImage {
    private String srcpath;
    private String subpath;
    private int x;
    private int y;
    private int width;
    private int height;

    public void setSrcpath(String srcpath) {
        this.srcpath = srcpath;
    }

    public void setSubpath(String subpath) {
        this.subpath = subpath;
    }

    public OperateImage() {
    }

    public OperateImage(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cut() throws IOException {
        FileInputStream is = null;
        ImageInputStream iis = null;
        try {
            is = new FileInputStream(this.srcpath);
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpg");
            ImageReader reader = it.next();
            iis = ImageIO.createImageInputStream(is);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(this.x, this.y, this.width, this.height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, "jpg", new File(this.subpath));
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (iis != null) {
                iis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cut(InputStream is, int pix) throws Exception {
        ImageInputStream iis = null;
        try {
            byte[] b = this.readInputStream(is, pix);
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpg");
            ImageReader reader = it.next();
            is = new ByteArrayInputStream(b);
            iis = ImageIO.createImageInputStream(is);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(this.x, this.y, this.width, this.height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, "jpg", new File(this.subpath));
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (iis != null) {
                iis.close();
            }
        }
    }

    public byte[] readInputStream(InputStream inStream, int pix) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.resizeImage(inStream, outStream, pix, "jpg");
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public void resizeImage(InputStream is, OutputStream os, int size, String format) throws IOException {
        BufferedImage prevImage = ImageIO.read(is);
        double width = prevImage.getWidth();
        double height = prevImage.getHeight();
        double percent = (double)size / height;
        int newWidth = (int)(width * percent);
        int newHeight = (int)(height * percent);
        BufferedImage image = new BufferedImage(newWidth, newHeight, 4);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(prevImage, 0, 0, newWidth, newHeight, null);
        ImageIO.write((RenderedImage)image, format, os);
        os.flush();
        os.close();
    }

    public static void main(String[] args) throws Exception {
        int pix = 900;
        FileInputStream fis = new FileInputStream("C:\\Users\\Daoyang\\Desktop\\pic\\7.jpg");
        OperateImage o = new OperateImage(0, 0, pix, 800);
        o.setSubpath("C:\\Users\\Daoyang\\Desktop\\pic\\22222.jpg");
        o.cut(fis, pix);
    }
}

