/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)HttpUtils.class.getName());

    public static String requestGet(String url) throws BizException {
        return HttpUtils.request(url, null, null, "GET");
    }

    public static String request(String url, Map<String, String> headers, String body, String method, Boolean isReturnNewHttpStructure, Integer timeout) throws BizException {
        String result = "";
        HttpURLConnection conn = HttpUtils.getConnect(url, headers, method);
        HttpUtils.setTimeout(conn, timeout);
        result = HttpUtils.getResult(conn, body, isReturnNewHttpStructure);
        return result;
    }

    public static void setTimeout(HttpURLConnection conn, Integer timeout) {
        if (timeout != null && timeout > 0) {
            conn.setReadTimeout(timeout);
        }
    }

    public static String request(String url, Map<String, String> headers, String body, String method) throws BizException {
        String result = "";
        HttpURLConnection conn = HttpUtils.getConnect(url, headers, method);
        result = HttpUtils.getResult(conn, body, false);
        return result;
    }

    private static HttpURLConnection getConnect(String url, Map<String, String> headers, String method) throws BizException {
        HttpURLConnection conn = null;
        try {
            URL url2 = new URL(url);
            conn = url.startsWith("https") ? (HttpsURLConnection)url2.openConnection() : (HttpURLConnection)url2.openConnection();
            if (headers != null && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            conn.setRequestMethod(method.toUpperCase());
            conn.setRequestProperty("Accept", "*/*");
            return conn;
        }
        catch (IOException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
    }

    private static String getResult(HttpURLConnection conn, String body, boolean isReturnNewHttpStructure) throws BizException {
        String result;
        block19: {
            result = "";
            OutputStream out = null;
            InputStream is = null;
            BufferedReader reader = null;
            try {
                int code;
                if (body != null) {
                    out = conn.getOutputStream();
                    out.write(body.getBytes("UTF-8"));
                }
                if ((code = conn.getResponseCode()) == 200) {
                    is = conn.getInputStream();
                    reader = new BufferedReader(new InputStreamReader(is));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        result = result + line;
                    }
                    if (!isReturnNewHttpStructure) break block19;
                    JSONObject j = new JSONObject();
                    j.put("statusCode", (Object)200);
                    try {
                        JSON json = (JSON)JSON.parse((String)result);
                        j.put("responseEntity", (Object)json);
                    }
                    catch (Exception ex) {
                        j.put("responseEntity", (Object)result);
                    }
                    result = j.toString();
                    break block19;
                }
                JSONObject j = new JSONObject();
                if (isReturnNewHttpStructure) {
                    j.put("statusCode", (Object)code);
                    j.put("message", (Object)conn.getResponseMessage());
                } else {
                    j.put("errCode", (Object)code);
                    j.put("msg", (Object)conn.getResponseMessage());
                }
                result = j.toString();
                conn.disconnect();
            }
            catch (IOException e) {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
            finally {
                conn.disconnect();
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void main(String[] args) throws BizException {
        System.out.println(HttpUtils.request("http://127.0.0.1:8107/biz/httpPostTest", null, null, "POST", true, 100));
    }
}

