/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.starrocks.store;

import com.manatee.common.domain.DBUpdate;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StarRocksUpdateProcess
implements IProcess {
    @Resource
    private IDBManager dBManager;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private ProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBUpdate dbUpdate = this.dBManager.getDBUpdate(content, "starrocks");
        int updateCount = this.dBManager.updateData(content, dbUpdate);
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)updateCount);
    }

    public String getName() {
        return "starRocksUpdate";
    }
}

