/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.customized;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InitCustomizedTable {
    private static final Logger log = LoggerFactory.getLogger(InitCustomizedTable.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Autowired
    private BaseModuleUtil baseModuleUtil;
    @Autowired
    private DBReadUtil dbReadUtil;

    @PostConstruct
    public void initBaseTable() {
        String lowcodeCustomizedTable = "lowcode_customized_table";
        String lowcodeCustomizedTableHistory = "lowcode_customized_table_history";
        String lowcodeCustomizedWorkflow = "lowcode_customized_workflow";
        String lowcodeCustomizedWorkflowHistory = "lowcode_customized_workflow_history";
        if (this.defaultDatabaseProductName.equals("dameng") || this.defaultDatabaseProductName.equals("oracle")) {
            lowcodeCustomizedTable = "LOWCODE_CUSTOMIZED_TABLE";
            lowcodeCustomizedTableHistory = "LOWCODE_CUSTOMIZED_TABLE_HISTORY";
            lowcodeCustomizedWorkflow = "LOWCODE_CUSTOMIZED_WORKFLOW";
            lowcodeCustomizedWorkflowHistory = "LOWCODE_CUSTOMIZED_WORKFLOW_HISTORY";
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeCustomizedTable)) {
            this.baseModuleUtil.initBaseTable("lowcode_customized_table");
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeCustomizedTableHistory)) {
            this.baseModuleUtil.initBaseTable("lowcode_customized_table_history");
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeCustomizedWorkflow)) {
            this.baseModuleUtil.initBaseTable("lowcode_customized_workflow");
        }
        if (!this.baseModuleUtil.isExistTable(lowcodeCustomizedWorkflowHistory)) {
            this.baseModuleUtil.initBaseTable("lowcode_customized_workflow_history");
        }
    }

    private boolean isExistFiled(String table, String filed) {
        String id = "id";
        if (this.defaultDatabaseProductName.equals("dameng")) {
            table = "\"" + table + "\"";
            id = "ID";
        }
        String sql = "select " + filed + " from " + table + " where " + id + " = 0";
        try {
            DBQuery dbQuery = new DBQuery();
            dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
            dbQuery.setDb("default");
            dbQuery.setSelectOne(Boolean.valueOf(true));
            dbQuery.setSql(sql);
            this.dbReadUtil.executeSelectSql(dbQuery, null);
            return true;
        }
        catch (BizException e) {
            return false;
        }
    }

    private void executeSqlScript(String table, String version) {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
        String initSql = BaseModuleUtil.parseFile((String)("initTableFiles/" + table + "/update/" + this.defaultDatabaseProductName + "_" + version + ".sql"));
        if (initSql != null && initSql.contains(";")) {
            String[] initSqlArray = initSql.split(";");
            try {
                for (String sql : initSqlArray) {
                    log.debug(sql);
                    dbQuery.setSql(sql);
                    this.dbReadUtil.executeNotSelectStatementSql(dbQuery, null);
                }
            }
            catch (BizException e) {
                log.error("\u53d8\u66f4\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u6267\u884c", (Object)table);
            }
        } else {
            dbQuery.setSql(initSql);
            try {
                this.dbReadUtil.executeNotSelectSql(dbQuery, null);
            }
            catch (BizException e) {
                log.error("\u53d8\u66f4\u57fa\u7840\u5e94\u7528\u8868\u3010{}\u3011\u5931\u8d25,\u8bf7\u624b\u52a8\u6267\u884c", (Object)table);
            }
        }
    }
}

