/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.postgresql.store;

import com.manatee.common.domain.DBUpdate;
import com.manatee.common.domain.In;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PostgresqlUpdateProcess
implements IProcess {
    @Resource
    private IDBManager dBManager;
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private ProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        DBUpdate dbUpdate = this.dBManager.getDBUpdate(content, "postgresql");
        this.paramsSetCaseSensitive(dbUpdate);
        int updateCount = this.dBManager.updateData(content, dbUpdate);
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)updateCount);
    }

    private void paramsSetCaseSensitive(DBUpdate dbUpdate) {
        List in;
        Map updateColumns;
        if (dbUpdate == null) {
            return;
        }
        Map queryCondition = dbUpdate.getQueryCondition();
        if (queryCondition != null) {
            HashMap newQueryCondition = new HashMap();
            for (Map.Entry entry : queryCondition.entrySet()) {
                if (NumberUtils.isNumber((String)((String)entry.getKey()))) {
                    newQueryCondition.put(entry.getKey(), entry.getValue());
                    continue;
                }
                newQueryCondition.put("\"" + (String)entry.getKey() + "\"", entry.getValue());
            }
            dbUpdate.setQueryCondition(newQueryCondition);
        }
        if ((updateColumns = dbUpdate.getUpdateColumns()) != null) {
            HashMap newUpdateColumns = new HashMap();
            for (Map.Entry entry : updateColumns.entrySet()) {
                newUpdateColumns.put("\"" + (String)entry.getKey() + "\"", entry.getValue());
            }
            dbUpdate.setUpdateColumns(newUpdateColumns);
        }
        if ((in = dbUpdate.getIn()) != null) {
            ArrayList<In> newIn = new ArrayList<In>();
            for (In inTemp : in) {
                inTemp.setKey("\"" + inTemp.getKey() + "\"");
                newIn.add(inTemp);
            }
            dbUpdate.setIn(newIn);
        }
    }

    public String getName() {
        return "postgreSqlUpdate";
    }
}

