/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.postgresql.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CloneUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.process.DynamicDbProcess;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PostgresqlSqlProcess
implements IProcess {
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private DynamicDbProcess dynamicDbProcess;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"sql"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, "postgresql");
        DBQuery dbQueryForCount = (DBQuery)CloneUtil.cloneByStream((Object)dbQuery);
        this.jointLimit(dbQuery);
        if (dbQuery.getSql().toLowerCase().trim().startsWith("select")) {
            JSONObject totalCountJson;
            JSON data = this.dBManager.executeSelectSql(content, dbQuery);
            if (data != null) {
                this.outputUtil.handleAndPutData(content, (Object)data);
            }
            if ((totalCountJson = this.queryTotalCount(dbQueryForCount, content)) != null) {
                this.outputUtil.unfoldPutData(content, (Map)totalCountJson);
            }
        } else {
            int count = this.dBManager.executeNotSelectSql(content, dbQuery);
            this.outputUtil.setDefaultReturnKey(content, "count");
            this.outputUtil.putData(content, (Object)count);
        }
    }

    private void jointLimit(DBQuery dbQuery) {
        String sqlSB = dbQuery.getSql();
        if (dbQuery.getPage() != null) {
            Integer pageNum = dbQuery.getPage().getPageNum();
            Integer pageSize = dbQuery.getPage().getPageSize();
            Integer skip = null;
            if (pageNum != null && pageSize != null) {
                skip = (pageNum - 1) * pageSize;
            }
            if (skip != null && pageSize != null) {
                dbQuery.setSql(sqlSB + " limit " + pageSize + " offset " + skip);
            } else if (pageSize != null) {
                dbQuery.setSql(sqlSB + " limit " + pageSize);
            }
        }
    }

    public JSONObject queryTotalCount(DBQuery dbQuery, ProcessContent content) throws BizException {
        if (!dbQuery.getSelectTotalCount().booleanValue() || dbQuery.getPage() == null) {
            return null;
        }
        if (dbQuery.getTable() == null) {
            dbQuery.setTable(dbQuery.getSql().split("from")[1].trim());
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        Integer totalCount = this.dbReadUtil.findCount(dbQuery);
        if (totalCount != null) {
            totalCountJson.put(totalCountReturnKey, (Object)totalCount);
            Integer pageSize = dbQuery.getPage().getPageSize();
            if (pageSize != null && pageSize > 0) {
                Integer totalPage = totalCount / pageSize;
                if (totalPage * pageSize < totalCount) {
                    Integer n = totalPage;
                    Integer n2 = totalPage = Integer.valueOf(totalPage + 1);
                }
                totalCountJson.put(totalPageReturnKey, (Object)totalPage);
            }
        }
        return totalCountJson;
    }

    public String getName() {
        return "postgreSqlSql";
    }
}

