/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dubbo.config;

import com.manatee.dubbo.config.DubboConsumerConfigCondition;
import com.manatee.manager.SpringContextManager;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class ManateeDubboConsumerConfig
implements ApplicationListener<ContextRefreshedEvent> {
    @Value(value="${dubbo.application.name:}")
    private String applicationName;
    @Value(value="${dubbo.registry.id:}")
    private String registryId;
    @Value(value="${dubbo.registry.address:}")
    private String registryAddress;
    @Value(value="${dubbo.registry.timeout:3000}")
    private Integer timeout;
    private Logger LOGGER = LoggerFactory.getLogger(DubboConsumerConfigCondition.class);
    private ApplicationConfig applicationConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationConfig getDubboApplicationConfig() {
        if (this.applicationConfig != null) {
            return this.applicationConfig;
        }
        Class<ManateeDubboConsumerConfig> clazz = ManateeDubboConsumerConfig.class;
        synchronized (ManateeDubboConsumerConfig.class) {
            if (this.applicationConfig != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.applicationConfig;
            }
            this.LOGGER.debug("init dubbo conf");
            ApplicationConfig application = new ApplicationConfig(this.applicationName);
            RegistryConfig registryConfig = new RegistryConfig();
            registryConfig.setAddress(this.registryAddress);
            registryConfig.setId(this.registryId);
            registryConfig.setTimeout(this.timeout);
            application.setRegistry(registryConfig);
            this.applicationConfig = application;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.applicationConfig;
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent applicationEvent) {
        ApplicationConfig bean = (ApplicationConfig)SpringContextManager.getBean(ApplicationConfig.class);
        this.LOGGER.debug("get coustmer dubbo conf");
        this.applicationConfig = bean;
    }
}

