/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.service;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ServiceException;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.io.FileUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.generation.entity.GenerateDTO;
import com.manatee.lowcode.generation.entity.ModuleDTO;
import com.manatee.lowcode.generation.entity.PackageDTO;
import com.manatee.lowcode.generation.service.GitService;
import com.manatee.lowcode.util.GlobalConf;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jgit.api.Git;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleJsonService {
    private static final Logger log = LoggerFactory.getLogger(ModuleJsonService.class);
    protected static Logger LOGGER = LoggerFactory.getLogger(ModuleJsonService.class);
    @Autowired
    private GitService gitService;
    @Resource
    private ManateeConfig manateeConfig;
    private Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);

    public String generateModuleJson(GenerateDTO dto) throws BizException {
        String generationTemp = "generationTemp";
        String newProjectPathStr = GlobalConf.TEMP_DIRECTORY;
        String rootJsonPath = newProjectPathStr + generationTemp;
        this.pushGitService(dto, rootJsonPath);
        String fromPath = newProjectPathStr + generationTemp;
        this.compress(fromPath, fromPath + ".zip");
        return fromPath + ".zip";
    }

    private void pushGitService(GenerateDTO dto, String rootJsonPath) throws BizException {
        FileUtil.del((File)new File(rootJsonPath));
        boolean isGit = true;
        String remotePath = this.manateeConfig.getConfigData().getGit().getUrl();
        String username = this.manateeConfig.getConfigData().getGit().getUsername();
        if (StrUtil.isBlank((CharSequence)remotePath) || StrUtil.isBlank((CharSequence)username)) {
            isGit = false;
        }
        try (Git git = null;){
            if (isGit) {
                git = this.gitService.cloneFromRemote(rootJsonPath);
                boolean exist = this.gitService.checkBranch(git);
                if (!exist) {
                    this.gitService.createBranch(git);
                } else {
                    this.gitService.checkoutBranch(git);
                }
            }
            String moduleJsonPath = rootJsonPath + "/lowcodeBaseModules";
            File moduleJsonFile = new File(moduleJsonPath);
            moduleJsonFile.mkdirs();
            String projectConfJsonPath = rootJsonPath + "/lowcodeProjectConf";
            File projectConfJsonFile = new File(projectConfJsonPath);
            projectConfJsonFile.mkdirs();
            List<PackageDTO> packageDTOList = dto.getPackageList();
            if (packageDTOList != null && packageDTOList.size() > 0) {
                ArrayList<ModuleDTO> moduleDTOList = new ArrayList<ModuleDTO>();
                for (PackageDTO packageDTO : packageDTOList) {
                    moduleDTOList.add(packageDTO.getModule());
                }
                this.creatModuleJson(moduleJsonPath, moduleDTOList);
            }
            if (dto.getProjectConf() != null) {
                this.creatProjectConfJson(projectConfJsonPath, dto.getProjectConf(), dto.getProjectId());
            }
            if (isGit) {
                this.gitService.addAll(git);
                this.gitService.commit(git);
                this.gitService.push(git);
            }
        }
    }

    private void creatModuleJson(String jsonDir, List<ModuleDTO> moduleList) throws BizException {
        for (ModuleDTO moduleDTO : moduleList) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>(1);
            objectMap.put("module", moduleDTO);
            this.generateByTemplate(objectMap, "moduleJson.json.ftl", jsonDir + "/" + moduleDTO.getProjectId() + "-" + moduleDTO.getModuleCode() + ".json");
        }
    }

    private void creatProjectConfJson(String jsonDir, JSONObject projectConfJson, Long projectId) throws BizException {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(1);
        objectMap.put("projectConfJson", projectConfJson.toJSONString());
        this.generateByTemplate(objectMap, "projectConfJson.json.ftl", jsonDir + "/" + projectId + ".json");
    }

    public String generateByTemplate(Map<String, Object> objectMap, String templateName, String toPath) {
        try {
            this.configuration.setClassForTemplateLoading(this.getClass(), "/template");
            this.configuration.setNumberFormat("#");
            Template template = this.configuration.getTemplate(templateName);
            File toFile = new File(toPath);
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(toFile);
            template.process(objectMap, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").name()));
            fileOutputStream.close();
            log.info("\u6587\u4ef6[" + toPath + "]\u521b\u5efa\u6210\u529f");
            return toFile.getPath();
        }
        catch (Exception e) {
            log.error("generateByTemplate error ,templateName:\u3010{}\u3011, toPath:\u3010{}\u3011, objectMap:\u3010{}\u3011,e:{}", new Object[]{templateName, toPath, objectMap, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(String fromPath, String toPath) {
        File fromFile = new File(fromPath);
        File toFile = new File(toPath);
        if (!fromFile.exists()) {
            throw new ServiceException(fromPath + "\u4e0d\u5b58\u5728\uff01");
        }
        try (FileOutputStream outputStream = new FileOutputStream(toFile);
             CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream, new CRC32());
             ZipOutputStream zipOutputStream = new ZipOutputStream(checkedOutputStream);){
            String baseDir = "";
            this.compress(fromFile, zipOutputStream, baseDir);
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            FileUtil.del((File)fromFile);
        }
    }

    private void compress(File file, ZipOutputStream zipOut, String baseDir) throws IOException {
        if (file.isDirectory()) {
            this.compressDirectory(file, zipOut, baseDir);
        } else {
            this.compressFile(file, zipOut, baseDir);
        }
    }

    private void compressFile(File file, ZipOutputStream zipOut, String baseDir) throws IOException {
        if (!file.exists()) {
            return;
        }
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int count;
            ZipEntry entry = new ZipEntry(baseDir + file.getName());
            zipOut.putNextEntry(entry);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                zipOut.write(data, 0, count);
            }
        }
    }

    private void compressDirectory(File dir, ZipOutputStream zipOut, String baseDir) throws IOException {
        Object[] files = dir.listFiles();
        if (files != null && ArrayUtils.isNotEmpty((Object[])files)) {
            for (Object file : files) {
                this.compress((File)file, zipOut, baseDir + dir.getName() + File.separator);
            }
        }
    }

    private void deleteFolder(File folder) {
        File[] fileList = folder.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    this.deleteFolder(file);
                    continue;
                }
                file.delete();
            }
        }
        folder.delete();
    }
}

