/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.rabbitmq.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.web.manager.ModularityManager;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class MessageListener {
    private Logger log = LoggerFactory.getLogger(MessageListener.class);
    @Resource
    private ModularityManager modularityManager;

    @RabbitListener(queues={"manatee_message_queue"})
    public void messageListener(Message message) {
        String bodyStr;
        if (message != null && StringUtils.isNotBlank((CharSequence)(bodyStr = new String(message.getBody()))) && JSONUtil.isJson((String)bodyStr)) {
            Long projectId = 0L;
            String code = "msgDistribute";
            JSONObject bodyJson = JSONObject.parseObject((String)bodyStr);
            String topic = bodyJson.getString("_topic");
            String tags = bodyJson.getString("_tags");
            String uniqueid = bodyJson.getString("_uniqueid");
            this.log.warn("\u6536\u5230\u6d88\u606f\uff1atopic:" + topic + ",tags\uff1a" + tags + ",uniqueid\uff1a" + uniqueid);
            HashMap<String, JSONObject> params = new HashMap<String, JSONObject>();
            bodyJson.remove((Object)"_topic");
            bodyJson.remove((Object)"_tags");
            params.put("value", bodyJson);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("_type", topic);
            param.put("_subType", tags);
            if (StringUtils.isNotBlank((CharSequence)uniqueid)) {
                param.put("_uniqueId", params.get("_uniqueid"));
            }
            param.put("params", params);
            ModularityResult modularityResult = this.modularityManager.executionModule(projectId, code, param);
            this.log.warn(JSONObject.toJSONString((Object)modularityResult));
        }
    }
}

