/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.web.manager;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.cache.CacheUtil;
import com.manatee.common.util.tool.cache.impl.TimedCache;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.common.util.tool.core.util.IdUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.config.log.Log;
import com.manatee.lowcode.domain.ModularityResult;
import com.manatee.lowcode.iutil.IModularityManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.handler.RsHandler;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.execute.DebugUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomizeModuleLogManager {
    private static final ConcurrentLinkedQueue<JSONObject> LOG_QUEUE = new ConcurrentLinkedQueue();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private static final TimedCache<Object, Object> LOG_CONF_MAP = CacheUtil.newTimedCache((long)60000L);
    private final Pattern PATTERN = Pattern.compile("\\{(.*?)\\}");
    @Resource
    private ManateeConfig manateeConfig;
    @Resource
    private IModularityManager modularityManager;

    public void init() {
        SCHEDULER.scheduleAtFixedRate(this::saveLogs, 1L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogs() {
        if (LOG_QUEUE.isEmpty()) {
            return;
        }
        ProcessContent processContent = new ProcessContent();
        processContent.setProjectId(Long.valueOf(0L));
        ThreadLocalConnection.INSTANCE.setProcessContent(processContent);
        Log log = this.manateeConfig.getLog();
        String saveLogModuleCode = null;
        if (log != null) {
            saveLogModuleCode = log.getSaveLogModuleCode();
        }
        int count = 100;
        ArrayList<DbEntity> insertListParams = new ArrayList<DbEntity>(count);
        while (count-- > 0 && !LOG_QUEUE.isEmpty()) {
            JSONObject logParams = LOG_QUEUE.poll();
            ProcessContent content = (ProcessContent)logParams.getObject("content", ProcessContent.class);
            Long projectId = content.getProjectId();
            DbEntity logConf = (DbEntity)logParams.getObject("logConf", DbEntity.class);
            if (StrUtil.isNotBlank((CharSequence)saveLogModuleCode)) {
                HashMap<String, Object> moduleParamsMap = new HashMap<String, Object>();
                moduleParamsMap.put("moduleCode", content.getCode());
                moduleParamsMap.put("project_id", projectId);
                Map data = content.getRequest();
                JSONObject param = new JSONObject();
                param.putAll(data);
                param.remove((Object)"cells");
                moduleParamsMap.put("param", param);
                JSONObject loginUser = new JSONObject();
                loginUser.put("userId", content.getTempContent("userId"));
                moduleParamsMap.put("loginUser", loginUser);
                ModularityResult modularityResult = this.modularityManager.executionModule(projectId, saveLogModuleCode, moduleParamsMap);
                continue;
            }
            DbEntity moduleParams = null;
            try {
                moduleParams = DbEntity.create((String)"lowcode_module_run_log").setInsertTypeEnum(SqlBuilder.InsertTypeEnum.INSERT);
            }
            catch (BizException e) {
                e.printStackTrace();
            }
            moduleParams.set("module_code", (Object)content.getCode());
            moduleParams.set("project_id", (Object)projectId);
            moduleParams.set("biz_id", (Object)0L);
            moduleParams.set("id", (Object)IdUtil.getSnowflake((long)1L, (long)1L).nextId());
            moduleParams.set("trace_id", (Object)content.getTraceId());
            String action = logConf.getStr("action");
            Matcher matcher = this.PATTERN.matcher(action);
            while (matcher.find()) {
                String paramName = matcher.group(1);
                Object value = content.getValue(paramName);
                if (value == null) {
                    action = action.replaceFirst("\\{" + paramName + "\\}", "--");
                    continue;
                }
                if (value instanceof Date) {
                    value = DateUtil.formatDateTime((Date)((Date)value));
                }
                action = action.replaceFirst("\\{" + paramName + "\\}", value.toString());
            }
            moduleParams.set("action", (Object)action);
            moduleParams.set("request_method", content.getTempContent("requestMethod"));
            moduleParams.set("request_url", content.getTempContent("requestUri"));
            moduleParams.set("user_ip", content.getTempContent("remoteIP"));
            moduleParams.set("user_id", content.getTempContent("userId"));
            moduleParams.set("user_agent", content.getTempContent("userAgent"));
            moduleParams.set("tenant_id", content.getTempContent("tenantId"));
            moduleParams.set("create_user", content.getTempContent("userId"));
            moduleParams.set("modified_user", content.getTempContent("userId"));
            Date date = new Date();
            moduleParams.set("gmt_create", (Object)date);
            moduleParams.set("gmt_modified", (Object)date);
            moduleParams.set("valid", (Object)0);
            insertListParams.add(moduleParams);
        }
        if (CollUtil.isEmpty(insertListParams)) {
            return;
        }
        try {
            DbClient.use().insert(insertListParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbEntity getConfMap(Long projectId, String moduleCode) {
        DbEntity logConf = (DbEntity)LOG_CONF_MAP.get((Object)"");
        if (logConf != null) {
            return logConf;
        }
        try {
            ProcessContent processContent = new ProcessContent();
            processContent.setProjectId(Long.valueOf(0L));
            ThreadLocalConnection.INSTANCE.setProcessContent(processContent);
            HashMap<String, Object> conditionMap = new HashMap<String, Object>();
            conditionMap.put("valid", 0);
            conditionMap.put("module_code", moduleCode);
            conditionMap.put("project_id", projectId);
            DbEntity db = DbEntity.create((String)"lowcode_module_run_log_config").setWhereConditionForDbQuery(conditionMap);
            List aDefault = (List)DbClient.use((String)"default").find(db, (RsHandler)ManateeListHandler.create((Boolean)true, (String)"lowerCase"), new String[0]);
            if (CollUtil.isEmpty((Collection)aDefault)) {
                DbEntity dbEntity = null;
                return dbEntity;
            }
            LOG_CONF_MAP.put((Object)(projectId + "_" + moduleCode), aDefault.get(0));
            DbEntity dbEntity = (DbEntity)aDefault.get(0);
            return dbEntity;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
        return null;
    }

    public void log(ProcessContent content) {
        Object moduleCode;
        if (DebugUtil.isDebug((ProcessContent)content)) {
            return;
        }
        Long projectId = content.getProjectId();
        DbEntity logConf = this.getConfMap(projectId, (String)(moduleCode = content.getTempContent("lowcodeModule")));
        if (logConf == null) {
            return;
        }
        JSONObject logParams = new JSONObject();
        logParams.put("logConf", (Object)logConf);
        logParams.put("content", (Object)content);
        LOG_QUEUE.add(logParams);
    }
}

