/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.ProcessDataUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Service;

@Service
public class FieldsUtil {
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ProcessDataUtil processDataUtil;

    public Map<String, Object> getAddFields(ProcessContent content, JSONObject conf) {
        Map<String, Object> resResultMp = this.getQueryResultKey(content, conf);
        return this.getFieldMap(content, resResultMp);
    }

    public Map<String, Object> getAddFieldsFromInput(ProcessContent content) {
        Map resResultMp = (Map)this.processDataUtil.getData(content);
        return this.getFieldMap(content, resResultMp);
    }

    public Map<String, String> getAddStrFields(ProcessContent content, JSONObject conf) {
        Map<String, Object> resResultMp = this.getQueryResultKey(content, conf);
        Map<String, Object> fieldMap = this.getFieldMap(content, resResultMp);
        HashedMap fieldStrMap = new HashedMap();
        for (Map.Entry<String, Object> field : fieldMap.entrySet()) {
            String value = this.convertValue(field.getValue());
            fieldStrMap.put(field.getKey(), value);
        }
        return fieldStrMap;
    }

    protected Map<String, Object> getQueryResultKey(ProcessContent content, JSONObject conf) {
        Map resResultMp = null;
        if (conf.containsKey((Object)"queryResultKey")) {
            String queryResultKey = conf.getString("queryResultKey");
            Object resResult = content.getResponseSubValue(queryResultKey);
            if (resResult == null) {
                resResult = content.getRequestSubValue(queryResultKey);
            }
            resResultMp = (Map)resResult;
        } else {
            resResultMp = content.getResponse();
        }
        return resResultMp;
    }

    protected Map<String, Object> getFieldMap(ProcessContent content, Map<String, Object> resResultMp) {
        String[] fieldKeys;
        JSONObject conf = content.getStepConf();
        String fieldKeysStr = conf.getString("fieldKeys");
        if (StringUtil.isBlank((String)fieldKeysStr)) {
            return resResultMp;
        }
        Object filterNull = conf.get((Object)"filterNull");
        fieldKeysStr = this.variableUtil.calVar(content, fieldKeysStr);
        Map<String, Object> fields = new HashMap<String, Object>();
        for (String field : fieldKeys = fieldKeysStr.split(StrSplit.D)) {
            Object fieldV = resResultMp.get(field);
            if (this.filterNull(filterNull, fieldV)) continue;
            fields.put(field, fieldV);
        }
        fields = this.formatNewKeys(content, fields, fieldKeys);
        return fields;
    }

    private boolean filterNull(Object filterNull, Object fieldV) {
        List list;
        if (fieldV == null) {
            return true;
        }
        if (filterNull == null) {
            return false;
        }
        if (fieldV instanceof String && StringUtil.isBlank((String)((String)fieldV))) {
            return true;
        }
        return fieldV instanceof List && (list = (List)fieldV).size() == 0;
    }

    private Map<String, Object> formatNewKeys(ProcessContent content, Map<String, Object> fields, String[] fieldKeys) {
        JSONObject conf = content.getStepConf();
        String newkeysStr = conf.getString("newkeys");
        if (StringUtil.isNotBlank((String)(newkeysStr = this.variableUtil.calVar(content, newkeysStr)))) {
            HashMap<String, Object> newFields = new HashMap<String, Object>();
            String[] newkeys = newkeysStr.split(StrSplit.D);
            for (int i = 0; i < fieldKeys.length; ++i) {
                String oldKey = fieldKeys[i];
                Object value = fields.get(oldKey);
                if (value == null) continue;
                String newkey = newkeys[i];
                newFields.put(newkey, value);
            }
            if (newFields.size() > 0) {
                return newFields;
            }
        }
        return fields;
    }

    private String convertValue(Object fieldV) {
        String valueStr = fieldV instanceof Map || fieldV instanceof List ? JSON.toJSONString((Object)fieldV) : String.valueOf(fieldV);
        return valueStr;
    }
}

