/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ContentUtil {
    @Resource
    private VariableUtil variableUtil;

    public JSONObject getParam(ProcessContent content, JSONObject conf) {
        JSONObject param = conf.getJSONObject("param");
        if (param == null) {
            return new JSONObject();
        }
        String paramStr = this.variableUtil.calVar(content, param.toString());
        return JSONObject.parseObject((String)paramStr);
    }

    public static void putValue(ProcessContent content, Object data) {
        if (data == null) {
            return;
        }
        JSONObject conf = content.getStepConf();
        String queryResultKey = "QUERY_RESULT";
        if (conf.containsKey((Object)"queryResultKey")) {
            queryResultKey = conf.getString("queryResultKey");
        }
        JSONObject value = ContentUtil.formatJson(queryResultKey, data);
        Boolean putRequest = conf.getBoolean("putRequest");
        if (putRequest != null && putRequest.booleanValue()) {
            content.putRequest(value.getInnerMap());
        } else {
            content.putResponse(value.getInnerMap());
        }
    }

    public static JSONObject formatJson(String batchKey, Object value) {
        if (StringUtil.isBlank((String)batchKey)) {
            batchKey = "batchResult";
        }
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        JSONObject result = new JSONObject();
        if (value instanceof JSONArray) {
            result.put(batchKey, value);
            return result;
        }
        if (value instanceof List) {
            result.put(batchKey, value);
            return result;
        }
        String data = (String)value;
        if (StringUtil.isArry((String)data)) {
            JSONArray array = JSONArray.parseArray((String)data);
            result.put(batchKey, (Object)array);
        } else {
            result = JSONObject.parseObject((String)data, (Feature[])new Feature[]{Feature.OrderedField});
        }
        return result;
    }
}

