/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.thirdparty;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DingdingTextMessage;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.DingdingMessageUtils;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DingdingProcess
implements IProcess {
    protected Logger log = LoggerFactory.getLogger(DingdingProcess.class);
    @Resource
    private ProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"url"});
        JSONObject conf = content.getStepConf();
        String url = conf.getString("url");
        String msg = (String)content.getRequestSubValue("dingdingMsg");
        DingdingTextMessage textMessage = new DingdingTextMessage(msg);
        Boolean isAtAll = conf.getBoolean("isAtAll");
        textMessage.setIsAtAll(isAtAll.booleanValue());
        DingdingMessageUtils.sendDingdingMessage((String)url, (DingdingTextMessage)textMessage);
    }

    public String getName() {
        return "dingdingProcess";
    }
}

