/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.config.oss.ManateeOssConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;

@Service
public class FileUploadManager {
    @Resource
    private ManateeOssConfig manateeOssConfig;

    public String uploadFile(InputStream file, String bucketName, String folder, String suffix) throws BizException {
        OSS ossClient = this.getOssClient();
        String url = "";
        String ownDomain = this.manateeOssConfig.getOwnDomain();
        try {
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
            }
            byte[] fileBytes = IoUtil.readBytes((InputStream)file);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            String fileName = folder + this.buildFileName(new ByteArrayInputStream(fileBytes), suffix);
            if (!ossClient.doesObjectExist(bucketName, fileName)) {
                ossClient.putObject(bucketName, fileName, (InputStream)new ByteArrayInputStream(fileBytes));
            }
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.manateeOssConfig.getEndpoint();
            }
            url = ownDomain + "/" + fileName;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
        return url;
    }

    public String uploadFile(String fileName, InputStream file, String bucketName, String folder) throws BizException {
        OSS ossClient = this.getOssClient();
        String url = "";
        String ownDomain = this.manateeOssConfig.getOwnDomain();
        try {
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
            }
            byte[] fileBytes = IoUtil.readBytes((InputStream)file);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            fileName = folder + fileName;
            ossClient.putObject(bucketName, fileName, (InputStream)new ByteArrayInputStream(fileBytes));
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.manateeOssConfig.getEndpoint();
            }
            url = ownDomain + "/" + fileName;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
        return url;
    }

    public String uploadFileBase(String base, String bucketName, String folder, String suffix) throws BizException {
        String url = "";
        OSS ossClient = this.getOssClient();
        String ownDomain = this.manateeOssConfig.getOwnDomain();
        try {
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
            }
            byte[] imageByte = Base64.getDecoder().decode(base);
            folder = StringUtil.isBlank((String)folder) ? "" : folder + "/";
            String fileName = folder + this.buildBase64Name(imageByte, suffix);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageByte);
            if (!ossClient.doesObjectExist(bucketName, fileName)) {
                ossClient.putObject(bucketName, fileName, (InputStream)byteArrayInputStream);
            }
            if (StringUtil.isBlank((String)ownDomain)) {
                ownDomain = this.manateeOssConfig.getEndpoint();
            }
            url = ownDomain + "/" + fileName;
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
        return url;
    }

    public void deleteFile(String bucketName, String ossFilePath) throws BizException {
        OSS ossClient = this.getOssClient();
        try {
            if (!ossClient.doesBucketExist(bucketName)) {
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u6876\u540d\u79f0\u662f\u5426\u6b63\u786e");
            }
            ossClient.deleteObject(bucketName, ossFilePath);
        }
        catch (Exception e) {
            throw new BizException(ResultCode.BIZ_ERROR, (Throwable)e);
        }
        finally {
            ossClient.shutdown();
        }
    }

    private OSS getOssClient() throws BizException {
        String endpoint = this.manateeOssConfig.getEndpoint();
        String accessKeyId = this.manateeOssConfig.getAccessKeyId();
        String secretAccessKey = this.manateeOssConfig.getSecretAccessKey();
        if (StringUtil.isBlank((String)endpoint) || StringUtil.isBlank((String)accessKeyId) || StringUtil.isBlank((String)secretAccessKey)) {
            throw new BizException(ResultCode.CONF_ERROR, "OSS endpoint/accessKeyId/secretAccessKey \u914d\u7f6e\u9519\u8bef\u6216\u8005\u672a\u914d\u7f6e");
        }
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, secretAccessKey);
        return ossClient;
    }

    public String buildBase64Name(byte[] imageByte, String suffix) {
        try {
            String base64Str = Base64.getEncoder().encodeToString(imageByte);
            String fileName = DigestUtils.md5Hex((String)base64Str);
            StringBuilder sb = new StringBuilder();
            sb.append(fileName);
            sb.append(".");
            sb.append(suffix);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String buildFileName(InputStream file, String suffix) throws IOException {
        String fileName = DigestUtils.md5Hex((InputStream)file);
        StringBuilder sb = new StringBuilder();
        sb.append(fileName);
        sb.append(".");
        sb.append(suffix);
        return sb.toString();
    }
}

