/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.change;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import com.manatee.lowcode.function.change.ToJsonFun;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CsvToJsonFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(ToJsonFun.class);
    private String name = "csvToJson";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        String str = content.getParameters().get(0).toString();
        try {
            CsvSchema csv = CsvSchema.emptySchema().withHeader();
            CsvMapper csvMapper = new CsvMapper();
            MappingIterator mappingIterator = csvMapper.reader().forType(Map.class).with((FormatSchema)csv).readValues(str);
            List list = mappingIterator.readAll();
            return list;
        }
        catch (Exception e) {
            log.info("[CsvToJsonFun.doFunction]_exception", (Throwable)e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0ccsv\u8f6cjson\u5f02\u5e38", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

