/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.elasticsearch.domain.ESQuery;
import com.manatee.elasticsearch.manager.ESManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchAggregationGroupProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private ESManager esManager;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"index"});
        ESQuery esQuery = this.esManager.getESQuery(content);
        esQuery.setIsAggregation(true);
        SearchRequest searchRequest = this.esManager.getSearchRequest(esQuery);
        SearchResponse searchResponse = this.esManager.getSearchResponse(searchRequest);
        JSON result = this.getResult(searchResponse, esQuery);
        this.outputUtil.handleAndPutData(content, (Object)result);
    }

    private JSON getResult(SearchResponse searchResponse, ESQuery esQuery) {
        List aggregationList = searchResponse.getAggregations().asList();
        JSONObject aggregationListJson = new JSONObject();
        for (Aggregation aggregation : aggregationList) {
            JSONObject aggregationJson = new JSONObject();
            Terms terms = (Terms)aggregation;
            for (Terms.Bucket bucket : terms.getBuckets()) {
                aggregationJson.put(bucket.getKeyAsString(), (Object)bucket.getDocCount());
                Aggregations subAggregationList = bucket.getAggregations();
                if (subAggregationList == null) continue;
                for (Aggregation subAggregation : subAggregationList) {
                    JSONObject subAggregationJson = new JSONObject();
                    Terms subTerms = (Terms)subAggregation;
                    for (Terms.Bucket subBucket : subTerms.getBuckets()) {
                        subAggregationJson.put(subBucket.getKeyAsString(), (Object)subBucket.getDocCount());
                    }
                    aggregationJson.put(bucket.getKeyAsString(), (Object)subAggregationJson);
                }
            }
            String aggName = esQuery.getGroup().getName() + (esQuery.getSubGroup() != null ? esQuery.getSubGroup().getName() : "");
            aggregationListJson.put(aggName, (Object)aggregationJson);
        }
        return aggregationListJson;
    }

    public String getName() {
        return "elasticsearchAggregationGroup";
    }
}

