/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process.biz;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StrUtils;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import com.manatee.redis.source.DtSourceManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BlacklistProcess
implements IProcess {
    @Resource
    private ProcessChain processChain;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private DtSourceManager dtSourceManager;
    private long UPDATE_TIME = 300000L;
    private Map<String, Long> TIME_MAP = new ConcurrentHashMap<String, Long>();
    private Set<String> BLACKLIST = new HashSet<String>();

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"steps"});
        JSONObject conf = content.getStepConf();
        boolean isExecute = this.isExecute(content, conf);
        if (isExecute) {
            List steps = ProcessDataSource.formatSteps((JSONObject)conf);
            this.processChain.executeSteps(content, steps);
        }
    }

    private boolean isExecute(ProcessContent content, JSONObject conf) {
        boolean isExecute = false;
        boolean enable = true;
        if (conf.containsKey((Object)"enable")) {
            enable = conf.getBoolean("enable");
        }
        if (enable) {
            this.initBlacklist(conf);
            if (this.BLACKLIST.isEmpty() || this.BLACKLIST.contains(StrUtils.GetString((Object)content.getValue("userId")))) {
                isExecute = true;
            }
        } else {
            isExecute = true;
        }
        return isExecute;
    }

    private void initBlacklist(JSONObject conf) {
        String key = conf.getString("key");
        Set<String> blacklist = this.getBlacklist(conf, key);
        Long lastTime = this.TIME_MAP.get(key);
        if (lastTime == null) {
            lastTime = 0L;
        }
        if (this.BLACKLIST.isEmpty() || System.currentTimeMillis() - lastTime > this.UPDATE_TIME) {
            if (blacklist != null) {
                this.BLACKLIST = blacklist;
            }
            this.TIME_MAP.put(key, System.currentTimeMillis());
        }
    }

    private Set<String> getBlacklist(JSONObject conf, String key) {
        int db = 6;
        if (conf.containsKey((Object)"db")) {
            db = conf.getInteger("db");
        }
        return this.dtSourceManager.getDtSource().zrange(db, key, 0L, -1L);
    }

    public String getName() {
        return "blacklistProcess";
    }
}

