/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.util;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellMergedStrategy
extends AbstractMergeStrategy {
    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        if (relativeRowIndex == null || relativeRowIndex == 0) {
            return;
        }
        Object currentData = cell.getCellTypeEnum() == CellType.STRING ? cell.getStringCellValue() : Double.valueOf(cell.getNumericCellValue());
        int currentRowIndex = cell.getRowIndex();
        int currentColumnIndex = cell.getColumnIndex();
        if (Objects.equals(currentData, "_cellMergeUp")) {
            List cellRangeAddresses = sheet.getMergedRegions();
            boolean isMerged = false;
            for (int i = 0; i < cellRangeAddresses.size(); ++i) {
                CellRangeAddress cellRangeAddress = (CellRangeAddress)cellRangeAddresses.get(i);
                if (!cellRangeAddress.isInRange(currentRowIndex - 1, currentColumnIndex)) continue;
                sheet.removeMergedRegion(i);
                cellRangeAddress.setLastRow(currentRowIndex);
                sheet.addMergedRegion(cellRangeAddress);
                isMerged = true;
            }
            if (!isMerged) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(currentRowIndex - 1, currentRowIndex, currentColumnIndex, currentColumnIndex);
                sheet.addMergedRegion(cellRangeAddress);
            }
        }
    }
}

