/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.process;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.FileUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.ZipUtil;
import com.manatee.excel.domain.WriteExcelTemplateBO;
import com.manatee.excel.util.ExceWriteUtil;
import com.manatee.lowcode.exp.util.SpecialSymbolsUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.GlobalConf;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ExcelWriteTemplateProcess
implements IProcess {
    @Resource
    protected InputUtil inputUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        String filePassword;
        String fileWatermark;
        LinkedHashMap<String, List<WriteExcelTemplateBO>> fileMap = new LinkedHashMap<String, List<WriteExcelTemplateBO>>();
        String filePath = this.variableUtil.calVarInConf(content, "filePath");
        if (StringUtil.isBlank((String)filePath)) {
            String classpath = this.variableUtil.calVarInConf(content, "classpath");
            filePath = "classpath:" + classpath;
        }
        if (StringUtil.isBlank((String)filePath)) {
            throw new BizException(ResultCode.CONF_ERROR, "file_path_is_null");
        }
        content.putTempContent("filePath", (Object)filePath);
        String suffixName = this.getFileSuffixUsingSubstring(filePath);
        if (StringUtil.isBlank((String)suffixName) || !StringUtil.equals((CharSequence)suffixName, (CharSequence)"xls") && !StringUtil.equals((CharSequence)suffixName, (CharSequence)"xlsx")) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6a21\u7248\u8def\u5f84\u4e0d\u5408\u6cd5");
        }
        String excelDataType = content.getStepConf().getString("excelDataType");
        if (StringUtils.equals((CharSequence)excelDataType, (CharSequence)"batch")) {
            this.handleBatchSheet(content, fileMap, suffixName);
        } else {
            this.processConfUtil.checkConf(content, new String[]{"config"});
            JSONArray config = (JSONArray)JSONArray.parse((String)JSON.toJSONString((Object)content.getStepConf("config")), (Feature[])new Feature[]{Feature.OrderedField});
            for (int i = 0; i < config.size(); ++i) {
                JSONObject conf = config.getJSONObject(i);
                this.handleASheet(content, conf, fileMap, suffixName);
            }
        }
        File tempDir = new File(GlobalConf.TEMP_DIRECTORY);
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        if (StringUtil.isNotBlank((String)(fileWatermark = content.getStepConfString("fileWatermark")))) {
            fileWatermark = this.variableUtil.calVar(content, fileWatermark);
        }
        if (StringUtil.isNotBlank((String)(filePassword = content.getStepConfString("filePassword")))) {
            filePassword = this.variableUtil.calVar(content, filePassword);
        }
        this.writeExcels(fileMap, filePath, fileWatermark, filePassword);
        List<String> fileList = this.getFileList(fileMap);
        String zipFileName = this.zip(content, fileList);
        String fileName = this.getFileName(fileList, zipFileName);
        if (fileName == null) {
            throw new BizException(ResultCode.BIZ_ERROR, "excel_file_is_null");
        }
        String url = GlobalConf.TEMP_DIRECTORY + fileName;
        content.getStepConf().put("returnKey", (Object)"lowcodeTempExcelUrl");
        this.outputUtil.putData(content, (Object)url);
    }

    private String getFileName(List<String> fileList, String zipFileName) {
        String fileName = null;
        if (zipFileName != null) {
            fileName = zipFileName;
        } else if (fileList.size() > 0) {
            fileName = fileList.get(0);
        }
        return fileName;
    }

    private void handleASheet(ProcessContent content, JSONObject conf, Map<String, List<WriteExcelTemplateBO>> fileMap, String suffixName) throws BizException {
        String sheetNameVar = conf.getString("sheetName");
        content.getStepConf().put("sheetName", (Object)sheetNameVar);
        String sheetName = this.variableUtil.calVarInConf(content, "sheetName");
        String tempSheetName = null;
        String tempSheetNameVar = conf.getString("tempSheetName");
        if (StringUtils.isNotEmpty((CharSequence)tempSheetNameVar)) {
            content.getStepConf().put("tempSheetName", (Object)tempSheetNameVar);
            tempSheetName = this.variableUtil.calVarInConf(content, "tempSheetName");
        }
        content.setTempConf(conf);
        String syntaxTypeByOne = conf.getString("syntaxTypeOneDataProcess");
        Map oneDate = this.inputUtil.getHandleObjectV2(content, "oneParams", syntaxTypeByOne);
        WriteExcelTemplateBO newExcelTemplateBO = new WriteExcelTemplateBO();
        if (StringUtils.isEmpty((CharSequence)tempSheetName)) {
            tempSheetName = sheetName;
        }
        newExcelTemplateBO.setTempSheetName(tempSheetName);
        if (StringUtils.isEmpty((CharSequence)sheetName)) {
            sheetName = tempSheetName;
        }
        newExcelTemplateBO.setSheetName(sheetName);
        newExcelTemplateBO.setOne(oneDate);
        String batchDataListType = conf.getString("batchDataListType");
        if (StringUtils.isBlank((CharSequence)batchDataListType) || StringUtils.equals((CharSequence)batchDataListType, (CharSequence)"oneDataList")) {
            String syntaxType = conf.getString("syntaxTypeDataProcess");
            List value = (List)this.inputUtil.getHandleDataV2(content, null, syntaxType);
            content.removeTempConf();
            List<Map<String, Object>> orderList = this.initHeadAndOrderColumn(conf, value);
            newExcelTemplateBO.setList(orderList);
        } else {
            JSONArray dataListConfig = (JSONArray)JSONArray.parse((String)JSON.toJSONString((Object)conf.get((Object)"dataListConfig")), (Feature[])new Feature[]{Feature.OrderedField});
            HashMap<String, List<Map<String, Object>>> batchList = new HashMap<String, List<Map<String, Object>>>();
            for (int i = 0; i < dataListConfig.size(); ++i) {
                JSONObject dataConfig = dataListConfig.getJSONObject(i);
                String paramsKey = dataConfig.getString("paramsKey");
                String listParams = dataConfig.getString("dataHandleBatch");
                List sheetData = (List)content.getRequest(paramsKey);
                JSONObject tempConf = content.getStepConf();
                tempConf.put("dataHandleTempBatch", (Object)listParams);
                content.getStep().setTempConf(tempConf);
                String syntaxType = dataConfig.getString("syntaxTypeDataProcess");
                List sheetDataNew = (List)this.inputUtil.handleDataV2(content, "dataHandleTemp", (Object)sheetData, syntaxType);
                Map listParamsMap = this.convertMap(listParams);
                List<Map<String, Object>> orderList = this.initBatchSheetOrderColumn(listParamsMap, sheetDataNew);
                batchList.put(paramsKey, orderList);
            }
            newExcelTemplateBO.setBatchList(batchList);
        }
        this.addExcelTemplateBO(content, newExcelTemplateBO, fileMap, 0, suffixName);
        content.removeTempConf();
    }

    private void handleBatchSheet(ProcessContent content, Map<String, List<WriteExcelTemplateBO>> fileMap, String suffixName) throws BizException {
        String tempSheetName = null;
        String tempSheetNameVar = content.getStepConf().getString("tempSheetName");
        if (StringUtils.isNotEmpty((CharSequence)tempSheetNameVar)) {
            content.getStepConf().put("tempSheetName", (Object)tempSheetNameVar);
            tempSheetName = this.variableUtil.calVarInConf(content, "tempSheetName");
        }
        String batchDataListType = content.getStepConf().getString("batchDataListType");
        Map oneDate = this.inputUtil.getHandleObject(content, "oneParams");
        String listParams = content.getStepConf().getString("dataHandleBatch");
        Map listParamsMap = this.convertMap(listParams);
        String paramsKey = content.getStepConf().getString("paramsKey");
        List batchSheet = (List)this.inputUtil.getHandleData(content, paramsKey);
        for (Map sheet : batchSheet) {
            Object sheetData;
            String sheetName = (String)sheet.get("sheetName");
            JSONObject tempConf = content.getStepConf();
            tempConf.put("dataHandleTempBatch", (Object)listParams);
            content.getStep().setTempConf(tempConf);
            String syntaxType = content.getStepConf().getString("syntaxTypeDataProcess");
            WriteExcelTemplateBO newExcelTemplateBO = new WriteExcelTemplateBO();
            newExcelTemplateBO.setTempSheetName(tempSheetName);
            if (StringUtils.isEmpty((CharSequence)sheetName)) {
                sheetName = tempSheetName;
            }
            newExcelTemplateBO.setSheetName(sheetName);
            newExcelTemplateBO.setOne(oneDate);
            if (StringUtils.isBlank((CharSequence)batchDataListType) || StringUtils.equals((CharSequence)batchDataListType, (CharSequence)"oneDataList")) {
                sheetData = (List)sheet.get("sheetData");
                List sheetDataNew = (List)this.inputUtil.handleDataV2(content, "dataHandleTemp", sheetData, syntaxType);
                List<Map<String, Object>> orderList = this.initBatchSheetOrderColumn(listParamsMap, sheetDataNew);
                newExcelTemplateBO.setList(orderList);
            } else {
                sheetData = (Map)sheet.get("sheetData");
                newExcelTemplateBO.setBatchList((Map<String, List<Map<String, Object>>>)sheetData);
            }
            this.addExcelTemplateBO(content, newExcelTemplateBO, fileMap, 0, suffixName);
        }
        content.removeTempConf();
    }

    private List<Map<String, Object>> initHeadAndOrderColumn(JSONObject conf, List<Map<String, Object>> beanMapList) throws BizException {
        ArrayList<Map<String, Object>> orderList = new ArrayList<Map<String, Object>>();
        String listParams = conf.getString("dataHandleBatch");
        Map listParamsMap = this.convertMap(listParams);
        if (listParamsMap == null || listParamsMap.size() <= 0) {
            return orderList;
        }
        ArrayList<String> headKeyList = new ArrayList<String>();
        for (Map.Entry entry : listParamsMap.entrySet()) {
            headKeyList.add((String)entry.getKey());
        }
        if (beanMapList == null || beanMapList.size() == 0) {
            return orderList;
        }
        for (Map map : beanMapList) {
            Map<String, Object> orderMap = this.orderColumn(headKeyList, map);
            orderList.add(orderMap);
        }
        return orderList;
    }

    private List<Map<String, Object>> initBatchSheetOrderColumn(Map<String, Object> listParamsMap, List<Map<String, Object>> beanMapList) throws BizException {
        ArrayList<Map<String, Object>> orderList = new ArrayList<Map<String, Object>>();
        if (listParamsMap == null || listParamsMap.size() <= 0) {
            return orderList;
        }
        ArrayList<String> headKeyList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : listParamsMap.entrySet()) {
            headKeyList.add(entry.getKey());
        }
        if (beanMapList == null || beanMapList.size() == 0) {
            return orderList;
        }
        for (Map map : beanMapList) {
            Map<String, Object> orderMap = this.orderColumn(headKeyList, map);
            orderList.add(orderMap);
        }
        return orderList;
    }

    private void writeExcels(Map<String, List<WriteExcelTemplateBO>> fileMap, String filePath, String fileWatermark, String filePassword) throws BizException {
        for (Map.Entry<String, List<WriteExcelTemplateBO>> aMap : fileMap.entrySet()) {
            String writeFilePath;
            File file1;
            String fileName = aMap.getKey();
            StringBuilder sb = new StringBuilder(GlobalConf.TEMP_DIRECTORY).append(fileName);
            String file = sb.toString();
            if (fileName.contains("/") && !(file1 = new File(writeFilePath = file.substring(0, file.lastIndexOf("/")))).exists()) {
                file1.mkdirs();
            }
            ExceWriteUtil.writeExcelTemplate(file, aMap.getValue(), filePath, fileWatermark, filePassword);
        }
    }

    private List<String> getFileList(Map<String, List<WriteExcelTemplateBO>> fileMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, List<WriteExcelTemplateBO>> aMap : fileMap.entrySet()) {
            list.add(aMap.getKey());
        }
        return list;
    }

    private Map<String, Object> orderColumn(List<String> headKeyList, Map<String, Object> data) {
        LinkedHashMap<String, Object> orderMap = new LinkedHashMap<String, Object>();
        for (String string : headKeyList) {
            Object dataValue = data.get(string);
            orderMap.put(string, dataValue);
        }
        if (data.size() == 0) {
            return orderMap;
        }
        for (Map.Entry entry : data.entrySet()) {
            Object aData = orderMap.get(entry.getKey());
            if (aData != null) continue;
            orderMap.put((String)entry.getKey(), entry.getValue());
        }
        return orderMap;
    }

    private void addExcelTemplateBO(ProcessContent content, WriteExcelTemplateBO excelBO, Map<String, List<WriteExcelTemplateBO>> fileMap, Integer index, String suffixName) {
        String file = this.getFileName(content, index, suffixName);
        excelBO.setFile(file);
        List<WriteExcelTemplateBO> list = fileMap.get(file);
        if (list == null) {
            list = new ArrayList<WriteExcelTemplateBO>();
            fileMap.put(file, list);
        }
        list.add(excelBO);
    }

    private String getFileName(ProcessContent content, Integer index, String suffixName) {
        if (StringUtil.isBlank((String)suffixName)) {
            suffixName = "xls";
        }
        String name = this.getName(content);
        if (index <= 0) {
            String fileName = name + "." + suffixName;
            return fileName;
        }
        String fileName = name + "_" + index + "." + suffixName;
        return fileName;
    }

    private String getName(ProcessContent content) {
        String fileName = (String)content.getStepConf().get((Object)"fileName");
        if (StringUtil.isNotBlank((String)fileName)) {
            fileName = this.variableUtil.calVar(content, fileName);
            content.putTempContent("fileName", (Object)fileName);
            return fileName;
        }
        Long userId = content.getUserId();
        String name = "excel_write";
        if (userId != null) {
            name = userId + "";
        }
        return name;
    }

    private String zip(ProcessContent content, List<String> fileList) {
        if (!this.needZip(content, fileList)) {
            return null;
        }
        String name = this.getName(content);
        String zipFileName = "zip_" + name + ".zip";
        StringBuilder sb = new StringBuilder(GlobalConf.TEMP_DIRECTORY).append(zipFileName);
        String zipFile = sb.toString();
        try {
            ZipUtil.zip(fileList, (String)zipFile);
            FileUtil.deleteFiles(fileList);
            return zipFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean needZip(ProcessContent content, List<String> fileList) {
        if (fileList.size() > 1) {
            return true;
        }
        Object zip = this.processConfUtil.getConf(content, "zip", (Object)Boolean.FALSE);
        return !Boolean.FALSE.equals(zip);
    }

    private Map convertMap(String exp) {
        if (StringUtil.isBlank((String)exp)) {
            return null;
        }
        String newExp = SpecialSymbolsUtil.specialSymbolHandle((String)exp);
        String[] newExpArr = newExp.split(";");
        HashMap<String, String> map = new HashMap<String, String>(newExpArr.length);
        for (String str : newExpArr) {
            String[] strArr = str.split("=");
            map.put(strArr[0], strArr[1]);
        }
        return map;
    }

    private String getFileSuffixUsingSubstring(String fileName) {
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public String getName() {
        return "excelWriteTemplate";
    }

    public static void main(String[] args) {
        String filePath = "D:\\java\\test-1.xls";
        ExcelWriter templateWorkbook = EasyExcel.write((String)"D:\\java\\test-a.xls", List.class).withTemplate(filePath).build();
        WriteSheet sheet = EasyExcel.writerSheet((String)"Sheet2").build();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (int i = 0; i < 10; ++i) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)i);
            jsonObject.put("name", (Object)("aaa" + i));
            list.add(jsonObject);
        }
        FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
        templateWorkbook.fill(list, fillConfig, sheet);
        templateWorkbook.finish();
    }
}

