/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.excel.domain.QueryExcel;
import com.manatee.excel.domain.SheetDataMap;
import com.manatee.excel.util.ExcelReadUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ExcelReadProcess
implements IProcess {
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"config"});
        String localFilePath = this.variableUtil.calVarInConf(content, "localFilePath");
        String needDel = this.variableUtil.calVarInConf(content, "needDel");
        InputStream file = localFilePath != null ? this.getLocalFileInputStreamAndJudgeNeedDel(localFilePath, needDel) : content.getFile();
        QueryExcel query = new QueryExcel();
        query.setFile(file);
        JSONArray config = (JSONArray)content.getStepConf("config");
        this.initSheets(config, query);
        SheetDataMap sheetDataMap = ExcelReadUtil.readSheets(query);
        for (int i = 0; i < config.size(); ++i) {
            JSONObject conf = config.getJSONObject(i);
            String dataHandleBatch = this.variableUtil.calVar(content, conf.getString("dataHandleBatch"));
            conf.put("dataHandleBatch", (Object)dataHandleBatch);
            this.handleASheet(content, sheetDataMap, conf);
        }
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private InputStream getLocalFileInputStreamAndJudgeNeedDel(String localFilePath, String needDel) throws BizException {
        File file = null;
        try {
            FileInputStream inputStream;
            file = new File(localFilePath);
            FileInputStream fileInputStream = inputStream = new FileInputStream(file);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "file not found", (Throwable)e);
        }
        finally {
            if (StringUtil.isNotBlank((String)needDel) && "yes".equals(needDel) && file != null && file.exists()) {
                file.delete();
            }
        }
    }

    private void handleASheet(ProcessContent content, SheetDataMap sheetDataMap, JSONObject conf) throws BizException {
        List<Map<String, Object>> dataList;
        Object sheet = null;
        if (sheetDataMap.isHasSheetName()) {
            sheet = conf.getString("sheetName");
            if (sheet.toString().startsWith("${") && sheet.toString().endsWith("}")) {
                sheet = content.getRequest(sheet.toString().substring(2, sheet.toString().length() - 1)).toString();
            }
        } else {
            sheet = conf.getInteger("sheetNo");
        }
        Integer startLine = 1;
        if (conf.containsKey((Object)"startLine")) {
            if (conf.getString("startLine").startsWith("${") && conf.getString("startLine").endsWith("}")) {
                String key = conf.getString("startLine").substring(2, conf.getString("startLine").length() - 1);
                if (content.getRequest().containsKey(key)) {
                    startLine = Integer.valueOf(content.getRequest(key).toString());
                }
            } else {
                startLine = conf.getInteger("startLine");
            }
        }
        if ((dataList = sheetDataMap.getDataList(sheet, startLine)) == null) {
            return;
        }
        content.setTempConf(conf);
        this.outputUtil.handleAndPutData(content, dataList);
        content.removeTempConf();
    }

    public void initSheets(JSONArray config, QueryExcel query) {
        for (int i = 0; i < config.size(); ++i) {
            JSONObject conf = config.getJSONObject(i);
            String sheet = conf.getString("sheetName");
            if (sheet != null) {
                query.addSheet(sheet);
                continue;
            }
            Integer sheetNo = conf.getInteger("sheetNo");
            query.addSheet(sheetNo);
        }
    }

    public String getName() {
        return "excelRead";
    }
}

