/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.excel.domain;

import com.manatee.excel.domain.PieceData;
import com.manatee.excel.domain.SheetData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SheetDataMap {
    boolean hasSheetName = false;
    Map<Object, SheetData> map = new LinkedHashMap<Object, SheetData>();

    public void addData(PieceData data) {
        SheetData sheetData;
        Object sheet = data.getSheetNo();
        if (this.hasSheetName) {
            sheet = data.getSheetName();
        }
        if ((sheetData = this.map.get(sheet)) == null) {
            sheetData = new SheetData();
        }
        sheetData.addData(data);
        this.map.put(sheet, sheetData);
    }

    public List<Map<String, Object>> getDataList(Object sheet, Integer startLine) {
        SheetData sheetData = this.map.get(sheet);
        if (sheetData == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<PieceData> pieceDataList = sheetData.getDataList(startLine);
        if (pieceDataList == null || pieceDataList.size() == 0) {
            return list;
        }
        for (PieceData pieceData : pieceDataList) {
            Map<String, Object> map = pieceData.getData();
            list.add(map);
        }
        return list;
    }

    public boolean isHasSheetName() {
        return this.hasSheetName;
    }

    public Map<Object, SheetData> getMap() {
        return this.map;
    }

    public void setHasSheetName(boolean hasSheetName) {
        this.hasSheetName = hasSheetName;
    }

    public void setMap(Map<Object, SheetData> map) {
        this.map = map;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SheetDataMap)) {
            return false;
        }
        SheetDataMap other = (SheetDataMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasSheetName() != other.isHasSheetName()) {
            return false;
        }
        Map<Object, SheetData> this$map = this.getMap();
        Map<Object, SheetData> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SheetDataMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasSheetName() ? 79 : 97);
        Map<Object, SheetData> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public String toString() {
        return "SheetDataMap(hasSheetName=" + this.isHasSheetName() + ", map=" + this.getMap() + ")";
    }
}

