/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.meta;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.ListUtil;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.meta.Column;
import com.manatee.lowcodedb.newdb.meta.ColumnIndexInfo;
import com.manatee.lowcodedb.newdb.meta.IndexInfo;
import com.manatee.lowcodedb.newdb.meta.Table;
import com.manatee.lowcodedb.newdb.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetaUtil.class);

    public static List<String> getTables(DataSource ds) {
        return MetaUtil.getTables(ds, TableType.TABLE);
    }

    public static List<String> getTables(DataSource ds, TableType ... types) {
        return MetaUtil.getTables(ds, null, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, TableType ... types) {
        return MetaUtil.getTables(ds, schema, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, String tableName, TableType ... types) {
        ArrayList<String> tables = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCatalog(conn);
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, Convert.toStrArray((Object)types));){
                if (null != rs) {
                    while (rs.next()) {
                        String table = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                        tables.add(table);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return tables;
    }

    public static String[] getColumnNames(ResultSet rs) throws DbRuntimeException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCatalog(conn);
            String schema = MetaUtil.getSchema(conn);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(catalog, schema, tableName, null);){
                if (null != rs) {
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            stringArray = columnNames.toArray(new String[0]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return stringArray;
    }

    public static DbEntity createLimitedEntity(DataSource ds, String tableName) throws BizException {
        String[] columnNames = MetaUtil.getColumnNames(ds, tableName);
        return DbEntity.create(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        return MetaUtil.getTableMeta(ds, null, null, tableName);
    }

    public static Table getTableMeta(DataSource ds, String catalog, String schema, String tableName) {
        Table table = Table.create(tableName);
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (null == catalog) {
                catalog = MetaUtil.getCatalog(conn);
            }
            table.setCatalog(catalog);
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            table.setSchema(schema);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, new String[]{TableType.TABLE.value()});){
                if (null != rs && rs.next()) {
                    table.setComment(rs.getString("REMARKS"));
                }
            }
            rs = metaData.getPrimaryKeys(catalog, schema, tableName);
            var8_9 = null;
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.addPk(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            rs = metaData.getColumns(catalog, schema, tableName, null);
            var8_9 = null;
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.setColumn(Column.create(table, rs));
                    }
                }
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            rs = metaData.getIndexInfo(catalog, schema, tableName, false, false);
            var8_9 = null;
            try {
                LinkedHashMap<String, IndexInfo> indexInfoMap = new LinkedHashMap<String, IndexInfo>();
                if (null != rs) {
                    while (rs.next()) {
                        if (0 == rs.getShort("TYPE")) continue;
                        String indexName = rs.getString("INDEX_NAME");
                        String key = StrUtil.join((CharSequence)"&", (Object[])new Object[]{tableName, indexName});
                        IndexInfo indexInfo = (IndexInfo)indexInfoMap.get(key);
                        if (null == indexInfo) {
                            indexInfo = new IndexInfo(rs.getBoolean("NON_UNIQUE"), indexName, tableName, schema, catalog);
                            indexInfoMap.put(key, indexInfo);
                        }
                        indexInfo.getColumnIndexInfoList().add(ColumnIndexInfo.create(rs));
                    }
                }
                table.setIndexInfoList(ListUtil.toList(indexInfoMap.values()));
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return table;
    }

    @Deprecated
    public static String getCataLog(Connection conn) {
        return MetaUtil.getCatalog(conn);
    }

    public static String getCatalog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException e) {
            return MetaUtil.getDruidCatalog(conn);
        }
    }

    public static String getDruidCatalog(Connection conn) {
        try {
            if (conn instanceof DruidPooledConnection) {
                DruidPooledConnection connProxy = (DruidPooledConnection)conn;
                if (null == (conn = connProxy.getConnection())) {
                    return null;
                }
                return conn.getCatalog();
            }
        }
        catch (Exception e) {
            LOG.error("getDruidSchema error, msg:\u3010{}\u3011", (Object)e.getMessage());
        }
        return null;
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException e) {
            return MetaUtil.getDruidSchema(conn);
        }
        catch (AbstractMethodError abstractMethodError) {
            return null;
        }
    }

    public static String getDruidSchema(Connection conn) {
        try {
            if (conn instanceof DruidPooledConnection) {
                DruidPooledConnection connProxy = (DruidPooledConnection)conn;
                if (null == (conn = connProxy.getConnection())) {
                    return null;
                }
                return conn.getSchema();
            }
        }
        catch (Exception e) {
            LOG.error("getDruidSchema error, msg:\u3010{}\u3011", (Object)e.getMessage());
        }
        return null;
    }

    public static List<String> getSchemas(Connection conn) {
        ArrayList<String> schemas = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getSchemas();){
                if (null != rs) {
                    while (rs.next()) {
                        String schema = rs.getString("TABLE_SCHEM");
                        if (!StrUtil.isNotBlank((CharSequence)schema)) continue;
                        schemas.add(schema);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get Schemas error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return schemas;
    }

    public static List<String> getCatalogs(Connection conn) {
        ArrayList<String> catalogs = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getCatalogs();){
                if (null != rs) {
                    while (rs.next()) {
                        String catalog = rs.getString("TABLE_CAT");
                        if (!StrUtil.isNotBlank((CharSequence)catalog)) continue;
                        catalogs.add(catalog);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get catalogs error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return catalogs;
    }

    public static List<String> getTablesBySchema(Connection conn, String catalog, String schema, String tableName) {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, Convert.toStrArray((Object)((Object)TableType.TABLE)));){
                if (null != rs) {
                    while (rs.next()) {
                        String table = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                        tables.add(table);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return tables;
    }

    public static List<String> getColumnNamesBySchemaAndTable(Connection conn, String catalog, String schema, String tableName) {
        ArrayList<String> columnNames = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(catalog, schema, tableName, null);){
                if (null != rs) {
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            return columnNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get columns error!", e);
        }
    }
}

