/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds.pooled;

import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.thread.ThreadUtil;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.ds.pooled.DbConfig;
import com.manatee.lowcodedb.newdb.ds.pooled.DbSetting;
import com.manatee.lowcodedb.newdb.ds.pooled.PooledConnection;
import com.manatee.lowcodedb.newdb.ds.simple.AbstractDataSource;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;

public class PooledDataSource
extends AbstractDataSource {
    private Queue<PooledConnection> freePool;
    private int activeCount;
    private final DbConfig config;

    public static synchronized PooledDataSource getDataSource(String group) {
        return new PooledDataSource(group);
    }

    public static synchronized PooledDataSource getDataSource() {
        return new PooledDataSource();
    }

    public PooledDataSource() {
        this("");
    }

    public PooledDataSource(String group) {
        this(new DbSetting(), group);
    }

    public PooledDataSource(DbSetting setting, String group) {
        this(setting.getDbConfig(group));
    }

    public PooledDataSource(DbConfig config) {
        this.config = config;
        this.freePool = new LinkedList<PooledConnection>();
        int initialSize = config.getInitialSize();
        try {
            while (initialSize-- > 0) {
                this.freePool.offer(this.newConnection());
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.config.getMaxWait());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Pooled DataSource is not allow to get special Connection!");
    }

    protected synchronized boolean free(PooledConnection conn) {
        --this.activeCount;
        return this.freePool.offer(conn);
    }

    public PooledConnection newConnection() throws SQLException {
        return new PooledConnection(this);
    }

    public DbConfig getConfig() {
        return this.config;
    }

    public PooledConnection getConnection(long wait) throws SQLException {
        try {
            return this.getConnectionDirect();
        }
        catch (Exception e) {
            ThreadUtil.sleep((long)wait);
            return this.getConnectionDirect();
        }
    }

    @Override
    public synchronized void close() {
        if (CollectionUtil.isNotEmpty(this.freePool)) {
            this.freePool.forEach(PooledConnection::release);
            this.freePool.clear();
            this.freePool = null;
        }
    }

    protected void finalize() {
        IoUtil.close((Closeable)this);
    }

    private PooledConnection getConnectionDirect() throws SQLException {
        if (null == this.freePool) {
            throw new SQLException("PooledDataSource is closed!");
        }
        int maxActive = this.config.getMaxActive();
        if (maxActive <= 0 || maxActive < this.activeCount) {
            throw new SQLException("In used Connection is more than Max Active.");
        }
        PooledConnection conn = this.freePool.poll();
        if (null == conn || conn.open().isClosed()) {
            conn = this.newConnection();
        }
        ++this.activeCount;
        return conn;
    }
}

