/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds.pooled;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.ds.AbstractDSFactory;
import com.manatee.lowcodedb.newdb.ds.pooled.DbConfig;
import com.manatee.lowcodedb.newdb.ds.pooled.PooledDataSource;
import java.util.HashMap;
import javax.sql.DataSource;

public class PooledDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 8093886210895248277L;
    public static final String DS_NAME = "manatee-Pooled-DataSource";

    public PooledDSFactory() {
        this((HashMap<String, String>)null);
    }

    public PooledDSFactory(HashMap<String, String> setting) {
        super(DS_NAME, PooledDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, HashMap<String, String> poolSetting) {
        DbConfig dbConfig = new DbConfig();
        dbConfig.setUrl(jdbcUrl);
        dbConfig.setDriver(driver);
        dbConfig.setUser(user);
        dbConfig.setPass(pass);
        dbConfig.setInitialSize(this.getInt(poolSetting, "initialSize", 0));
        dbConfig.setMinIdle(this.getInt(poolSetting, "minIdle", 0));
        dbConfig.setMaxActive(this.getInt(poolSetting, "maxActive", 8));
        dbConfig.setMaxWait(this.getLong(poolSetting, "maxWait", 6000L));
        for (String key : KEY_CONN_PROPS) {
            String connValue = poolSetting.get(key);
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return new PooledDataSource(dbConfig);
    }

    private int getInt(HashMap<String, String> poolSetting, String name, int defule) {
        String value = poolSetting.get(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return defule;
        }
        return Integer.parseInt(value);
    }

    private long getLong(HashMap<String, String> poolSetting, String name, Long defule) {
        String value = poolSetting.get(name);
        if (StrUtil.isBlank((CharSequence)value)) {
            return defule;
        }
        return Long.parseLong(value);
    }
}

