/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.ds;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDSFactory
extends DSFactory {
    private static final long serialVersionUID = -6407302276272379881L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUtil.class);
    private final HashMap<String, String> setting;

    protected abstract DataSource createDataSource(String var1, String var2, String var3, String var4, HashMap<String, String> var5);

    public AbstractDSFactory(String dataSourceName, Class<? extends DataSource> dataSourceClass, HashMap<String, String> setting) {
        super(dataSourceName);
        Assert.notNull(dataSourceClass);
        DbUtil.setShowSqlGlobal(true, true, true, 1);
        this.setting = setting;
    }

    @Override
    public synchronized DataSource getDataSource(String group) throws BizException {
        DataSourceWrapper existedDataSource = ManateeDataSource.getDs(group);
        if (existedDataSource != null) {
            return existedDataSource;
        }
        return existedDataSource;
    }

    @Override
    public void close(String group) {
        if (group == null) {
            group = "";
        }
        try {
            DataSourceWrapper existedDataSource = ManateeDataSource.getDs(group);
            if (existedDataSource != null) {
                existedDataSource.close();
                ManateeDataSource.removeDs(group);
            }
        }
        catch (BizException e) {
            LOGGER.error("close error", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDSFactory other = (AbstractDSFactory)obj;
        return !(this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName));
    }
}

