/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect.impl;

import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.Page;
import com.manatee.lowcodedb.newdb.StatementUtil;
import com.manatee.lowcodedb.newdb.dialect.DialectName;
import com.manatee.lowcodedb.newdb.dialect.impl.AnsiSqlDialect;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

public class H2Dialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 1490520247974768214L;

    @Override
    public String dialectName() {
        return DialectName.H2.name();
    }

    @Override
    public SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getStartPosition()).append(" , ").append(page.getPageSize());
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, DbEntity entity, String ... keys) throws SQLException {
        Assert.notEmpty((Object[])keys, (String)"Keys must be not empty for H2 MERGE SQL.", (Object[])new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.create(this.wrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            Object value = stringObjectEntry.getValue();
            String field = (String)stringObjectEntry.getKey();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            fieldsPart.append(null != this.wrapper ? this.wrapper.wrap(field) : field);
            placeHolder.append("?");
            builder.addParams(value);
        }
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        builder.append("MERGE INTO ").append(tableName).append(" (").append(fieldsPart).append(") KEY(").append(ArrayUtil.join((Object[])keys, (CharSequence)", ")).append(") VALUES (").append(placeHolder).append(")");
        return StatementUtil.prepareStatement(conn, builder);
    }
}

