/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.dialect;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.dialect.DialectFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DriverUtil {
    public static String identifyDriver(String nameContainsProductInfo) {
        return DialectFactory.identifyDriver(nameContainsProductInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String identifyDriver(DataSource ds) {
        String driver;
        String driver2;
        if (ds instanceof DataSourceWrapper && StrUtil.isNotBlank((CharSequence)(driver2 = ((DataSourceWrapper)ds).getDriver()))) {
            return driver2;
        }
        Connection conn = null;
        try {
            try {
                conn = ds.getConnection();
            }
            catch (SQLException e) {
                throw new DbRuntimeException("Get Connection error !", e);
            }
            catch (NullPointerException e) {
                throw new DbRuntimeException("Unexpected NullPointException, maybe [jdbcUrl] or [url] is empty!", e);
            }
            driver = DriverUtil.identifyDriver(conn);
        }
        catch (Throwable throwable) {
            DbUtil.close(conn);
            throw throwable;
        }
        DbUtil.close(conn);
        return driver;
    }

    public static String identifyDriver(Connection conn) throws DbRuntimeException {
        String driver;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            driver = DriverUtil.identifyDriver(meta.getDatabaseProductName());
            if (StrUtil.isBlank((CharSequence)driver)) {
                driver = DriverUtil.identifyDriver(meta.getDriverName());
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Identify driver error!", e);
        }
        return driver;
    }
}

