/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public enum ThreadLocalConnection {
    INSTANCE;

    private final ThreadLocal<GroupedConnection> THREAD_LOCAL = new ThreadLocal();
    private final ThreadLocal<ProcessContent> THREAD_LOCAL_PROCESS = new ThreadLocal();

    public Connection get(DataSource ds) throws SQLException {
        ProcessContent processContent = this.THREAD_LOCAL_PROCESS.get();
        if (processContent != null && processContent.getTransactionCon() != null) {
            return processContent.getTransactionCon();
        }
        GroupedConnection groupedConnection = this.THREAD_LOCAL.get();
        if (null == groupedConnection) {
            groupedConnection = new GroupedConnection();
            this.THREAD_LOCAL.set(groupedConnection);
        }
        return groupedConnection.get(ds);
    }

    public void close(DataSource ds) {
        GroupedConnection groupedConnection = this.THREAD_LOCAL.get();
        if (null != groupedConnection) {
            groupedConnection.close(ds);
            if (groupedConnection.isEmpty()) {
                this.THREAD_LOCAL.remove();
            }
        }
    }

    public ProcessContent getProcessContent() {
        return this.THREAD_LOCAL_PROCESS.get();
    }

    public void setProcessContent(ProcessContent processContent) {
        this.THREAD_LOCAL_PROCESS.set(processContent);
    }

    public void removeProcessContent() {
        this.THREAD_LOCAL_PROCESS.remove();
    }

    public static class GroupedConnection {
        private final Map<DataSource, Connection> connMap = new HashMap<DataSource, Connection>(1, 1.0f);

        public Connection get(DataSource ds) throws SQLException {
            Connection conn = this.connMap.get(ds);
            if (null == conn || conn.isClosed()) {
                conn = ds.getConnection();
                this.connMap.put(ds, conn);
            }
            return conn;
        }

        public GroupedConnection close(DataSource ds) {
            Connection conn = this.connMap.get(ds);
            if (null != conn) {
                try {
                    if (!conn.getAutoCommit()) {
                        return this;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connMap.remove(ds);
                DbUtil.close(conn);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.connMap.isEmpty();
        }
    }
}

