/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.check.CheckUtil;
import com.manatee.check.ICheck;
import com.manatee.check.domain.CheckContent;
import com.manatee.common.domain.In;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.lang.Dict;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.ReflectUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.ConditionGroup;
import com.manatee.lowcodedb.newdb.sql.Direction;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.JoinQueryField;
import com.manatee.lowcodedb.newdb.sql.LogicalOperator;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.domain.ProcessContent;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DbEntity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private String pk;
    private Set<String> fieldNames;
    private SqlBuilder.InsertTypeEnum insertTypeEnum;
    private Collection<Join> joins;
    private boolean getOne;

    public static DbEntity create() throws BizException {
        return new DbEntity();
    }

    public static DbEntity create(String tableName) throws BizException {
        return new DbEntity(tableName);
    }

    public static <T> DbEntity parse(T bean) throws BizException {
        return DbEntity.create(null).parseBean((Object)bean);
    }

    public static <T> DbEntity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) throws BizException {
        return DbEntity.create(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public static <T> DbEntity parseWithUnderlineCase(T bean) throws BizException {
        return DbEntity.create(null).parseBean((Object)bean, true, true);
    }

    public DbEntity() {
    }

    public DbEntity(String tableName) {
        this.tableName = tableName;
    }

    public DbEntity(String tableName, boolean caseInsensitive) {
        super(caseInsensitive);
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DbEntity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public DbEntity setFieldNames(Collection<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            this.fieldNames = CollectionUtil.newHashSet((boolean)true, fieldNames);
        }
        return this;
    }

    public DbEntity setFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty((Object[])fieldNames)) {
            this.fieldNames = CollectionUtil.newLinkedHashSet((Object[])fieldNames);
        }
        return this;
    }

    public DbEntity addFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty((Object[])fieldNames)) {
            if (null == this.fieldNames) {
                return this.setFieldNames(fieldNames);
            }
            Collections.addAll(this.fieldNames, fieldNames);
        }
        return this;
    }

    public <T> DbEntity parseBean(T bean) {
        if (StrUtil.isBlank((CharSequence)this.tableName)) {
            this.setTableName(StrUtil.lowerFirst((CharSequence)bean.getClass().getSimpleName()));
        }
        return (DbEntity)super.parseBean(bean);
    }

    public <T> DbEntity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (StrUtil.isBlank((CharSequence)this.tableName)) {
            String simpleName = bean.getClass().getSimpleName();
            this.setTableName(isToUnderlineCase ? StrUtil.toUnderlineCase((CharSequence)simpleName) : StrUtil.lowerFirst((CharSequence)simpleName));
        }
        return (DbEntity)super.parseBean(bean, isToUnderlineCase, ignoreNullValue);
    }

    public DbEntity filter(String ... keys) {
        DbEntity result = new DbEntity(this.tableName);
        result.setFieldNames(this.fieldNames);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public DbEntity removeNew(String ... keys) {
        return (DbEntity)((Object)MapUtil.removeAny((Map)((Object)this.clone()), (Object[])keys));
    }

    public DbEntity set(String field, Object value) {
        Object old = this.get(field);
        if (old != null) {
            if (old instanceof ArrayList) {
                ((ArrayList)old).add(value);
                return this;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(old);
            list.add(value);
            value = list;
        }
        return (DbEntity)super.set(field, (Object)value);
    }

    public DbEntity setIgnoreNull(String field, Object value) {
        return (DbEntity)super.setIgnoreNull(field, value);
    }

    public Clob getClob(String field) {
        return (Clob)this.get(field, null);
    }

    public Blob getBlob(String field) {
        return (Blob)this.get(field, null);
    }

    public Time getTime(String field) {
        Object obj = this.get(field);
        Time result = null;
        if (null != obj) {
            try {
                result = (Time)obj;
            }
            catch (Exception e) {
                result = (Time)ReflectUtil.invoke((Object)obj, (String)"timeValue", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Date getDate(String field) {
        Object obj = this.get(field);
        Date result = null;
        if (null != obj) {
            try {
                result = (Date)obj;
            }
            catch (Exception e) {
                result = (Date)ReflectUtil.invoke((Object)obj, (String)"dateValue", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Timestamp getTimestamp(String field) {
        Object obj = this.get(field);
        Timestamp result = null;
        if (null != obj) {
            try {
                result = (Timestamp)obj;
            }
            catch (Exception e) {
                result = (Timestamp)ReflectUtil.invoke((Object)obj, (String)"timestampValue", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public String getStr(String field) {
        return this.getStr(field, CharsetUtil.CHARSET_UTF_8);
    }

    public String getStr(String field, Charset charset) {
        Object obj = this.get(field);
        if (obj instanceof Clob) {
            return SqlUtil.clobToStr((Clob)obj);
        }
        if (obj instanceof Blob) {
            return SqlUtil.blobToStr((Blob)obj, charset);
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StrUtil.str((byte[])rowId.getBytes(), (Charset)charset);
        }
        return super.getStr(field);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    public RowId getRowId(String field) {
        Object obj = this.get(field);
        if (null == obj) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw new DbRuntimeException("Value of field [{}] is not a rowid!", field);
    }

    public DbEntity setQueryColumnsForDbQuery(String tableName, String columns) {
        if (StrUtil.isNotBlank((CharSequence)columns) && !"*".equals(columns.trim())) {
            Object[] split = columns.split(",");
            if (ArrayUtil.isNotEmpty((Object[])split)) {
                for (int i = 0; i < split.length; ++i) {
                    split[i] = tableName + '.' + ((String)split[i]).trim();
                }
            }
            this.addFieldNames((String[])split);
        } else {
            this.addFieldNames(tableName + ".*");
        }
        return this;
    }

    public DbEntity setWhereConditionForDbQuery(Map<String, Object> conditionMap) {
        for (Map.Entry<String, Object> conditionMapEntry : conditionMap.entrySet()) {
            if (conditionMapEntry.getValue() == null) continue;
            Condition condition = Condition.parse(this.getTableName() + "." + conditionMapEntry.getKey(), conditionMapEntry.getValue());
            condition.setLinkOperator(LogicalOperator.AND);
            this.set(conditionMapEntry.getKey(), (Object)condition);
        }
        return this;
    }

    public DbEntity setInsertConditionListV2(List<Map> queryParamsArray) {
        for (Map object : queryParamsArray) {
            JSONObject jsonObject = (JSONObject)object;
            String fieldName = jsonObject.getString("fieldName");
            Object fieldValue = jsonObject.get((Object)"fieldValue");
            if (fieldName == null || fieldName.isEmpty()) continue;
            this.set(fieldName, fieldValue);
        }
        return this;
    }

    public DbEntity setInsertConditionList(List<Map> queryParamsArray) {
        for (Map object : queryParamsArray) {
            JSONObject jsonObject = (JSONObject)object;
            String fieldName = jsonObject.getString("fieldName");
            Object fieldValue = jsonObject.get((Object)"fieldValue");
            if (fieldName == null || fieldName.isEmpty() || fieldValue == null) continue;
            this.set(fieldName, fieldValue);
        }
        return this;
    }

    public DbEntity setWhereConditionListForDbQuery(String tableName, List<Map> queryParamsArray) {
        if (queryParamsArray == null) {
            return this;
        }
        ArrayList<ConditionGroup> groupList = new ArrayList<ConditionGroup>();
        int index = 0;
        for (Map object : queryParamsArray) {
            boolean isFilter;
            ++index;
            JSONObject jsonObject = (JSONObject)object;
            String fieldName = jsonObject.getString("fieldName");
            Object fieldValue = jsonObject.get((Object)"fieldValue");
            String symbol = jsonObject.getString("symbol");
            String conditionStr = jsonObject.getString("condition");
            Integer filterType = jsonObject.getInteger("filterType");
            String filterValue = jsonObject.getString("filterValue");
            Boolean isLeft = jsonObject.getBoolean("isLeft");
            if (isLeft == null) {
                isLeft = false;
            }
            if (isLeft.booleanValue()) {
                ConditionGroup conditionGroup = new ConditionGroup();
                groupList.add(conditionGroup);
                continue;
            }
            Boolean isRight = jsonObject.getBoolean("isRight");
            if (isRight == null) {
                isRight = false;
            }
            if (isRight.booleanValue()) {
                ConditionGroup conditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                groupList.remove((Object)conditionGroup);
                if (conditionStr == null || LogicalOperator.AND.toString().equalsIgnoreCase(conditionStr)) {
                    conditionGroup.setLinkOperator(LogicalOperator.AND);
                } else {
                    conditionGroup.setLinkOperator(LogicalOperator.OR);
                }
                if (groupList != null && groupList.size() > 0) {
                    ConditionGroup parentConditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                    parentConditionGroup.addConditions(conditionGroup);
                    continue;
                }
                this.set(String.valueOf(index), (Object)conditionGroup);
                continue;
            }
            if (fieldName == null || fieldName.isEmpty() || (isFilter = this.checkFieldValue(fieldName, symbol, fieldValue, filterType, filterValue, null))) continue;
            Condition condition = this.getCondition(tableName, fieldName, symbol, fieldValue, conditionStr);
            if (groupList != null && groupList.size() > 0) {
                ConditionGroup conditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                conditionGroup.addConditions(condition);
                continue;
            }
            this.set(tableName + '.' + fieldName, (Object)condition);
        }
        return this;
    }

    public DbEntity setWhereConditionListForDbQuery(String tableName, List<Map> queryParamsArray, ProcessContent content) {
        if (queryParamsArray == null) {
            return this;
        }
        ArrayList<ConditionGroup> groupList = new ArrayList<ConditionGroup>();
        int index = 0;
        for (Map object : queryParamsArray) {
            boolean isFilter;
            ++index;
            JSONObject jsonObject = (JSONObject)object;
            String fieldName = jsonObject.getString("fieldName");
            Object fieldValue = jsonObject.get((Object)"fieldValue");
            String symbol = jsonObject.getString("symbol");
            String conditionStr = jsonObject.getString("condition");
            Integer filterType = jsonObject.getInteger("filterType");
            String filterValue = jsonObject.getString("filterValue");
            Boolean isLeft = jsonObject.getBoolean("isLeft");
            if (isLeft == null) {
                isLeft = false;
            }
            if (isLeft.booleanValue()) {
                ConditionGroup conditionGroup = new ConditionGroup();
                groupList.add(conditionGroup);
                continue;
            }
            Boolean isRight = jsonObject.getBoolean("isRight");
            if (isRight == null) {
                isRight = false;
            }
            if (isRight.booleanValue()) {
                ConditionGroup conditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                groupList.remove((Object)conditionGroup);
                if (conditionStr == null || LogicalOperator.AND.toString().equalsIgnoreCase(conditionStr)) {
                    conditionGroup.setLinkOperator(LogicalOperator.AND);
                } else {
                    conditionGroup.setLinkOperator(LogicalOperator.OR);
                }
                if (groupList != null && groupList.size() > 0) {
                    ConditionGroup parentConditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                    parentConditionGroup.addConditions(conditionGroup);
                    continue;
                }
                this.set(String.valueOf(index), (Object)conditionGroup);
                continue;
            }
            if (fieldName == null || fieldName.isEmpty() || (isFilter = this.checkFieldValue(fieldName, symbol, fieldValue, filterType, filterValue, content))) continue;
            Condition condition = this.getCondition(tableName, fieldName, symbol, fieldValue, conditionStr);
            if (groupList != null && groupList.size() > 0) {
                ConditionGroup conditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                conditionGroup.addConditions(condition);
                continue;
            }
            this.set(tableName + '.' + fieldName, (Object)condition);
        }
        return this;
    }

    public DbEntity setInConditionForDbQuery(String tableName, List<In> in) {
        if (in != null) {
            for (In inItem : in) {
                if (StrUtil.isBlank((CharSequence)inItem.getKey()) || CollUtil.isEmpty((Collection)inItem.getValue()) && inItem.isFilterEmptyValue()) continue;
                Condition condition = new Condition(tableName + '.' + inItem.getKey(), "in", inItem.getValue());
                condition.setLinkOperator(LogicalOperator.AND);
                this.set(inItem.getKey(), (Object)condition);
            }
        }
        return this;
    }

    public Collection<Order> setSortConditionForDbQuery(String tableName, Map<String, Object> sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sort != null) {
            orders = new ArrayList(sort.size());
            for (Map.Entry<String, Object> orderEntry : sort.entrySet()) {
                Order order = new Order(tableName + '.' + orderEntry.getKey(), Direction.fromString(orderEntry.getValue().toString()));
                orders.add(order);
            }
        }
        return orders;
    }

    public Collection<Join> setJoinConditionForDbQuery(JSONArray joinJson, ProcessContent content) throws BizException {
        return this.setJoinConditionForDbQuery(joinJson, content, null, null);
    }

    public Collection<Join> setJoinConditionForDbQuery(JSONArray joinJson, ProcessContent content, String dataBaseName, IVariableUtil variableUtil) throws BizException {
        ArrayList<Join> joins = new ArrayList<Join>();
        if (joinJson == null) {
            return joins;
        }
        for (int i = 0; i < joinJson.size(); ++i) {
            JSONArray queryParamsArray;
            String[] beJoinedKeys;
            String joinType;
            String joinKey;
            String table;
            String columnsJoin;
            ArrayList<String[]> ons = new ArrayList<String[]>();
            JSONObject jsonObject = joinJson.getJSONObject(i);
            String beJoinedKey = jsonObject.getString("beJoinedKey");
            if (StringUtils.isNotEmpty((CharSequence)beJoinedKey) && variableUtil != null) {
                beJoinedKey = variableUtil.calVar(content, beJoinedKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)(columnsJoin = jsonObject.getString("columns"))) && variableUtil != null) {
                columnsJoin = variableUtil.calVar(content, columnsJoin);
            }
            if (StringUtils.isNotEmpty((CharSequence)(table = jsonObject.getString("table"))) && variableUtil != null) {
                table = variableUtil.calVar(content, table);
            }
            if (StringUtils.isNotEmpty((CharSequence)(joinKey = jsonObject.getString("joinKey"))) && variableUtil != null) {
                joinKey = variableUtil.calVar(content, joinKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)(joinType = jsonObject.getString("joinType"))) && variableUtil != null) {
                joinType = variableUtil.calVar(content, joinType);
            }
            if (beJoinedKey == null || table == null || joinKey == null) {
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u5173\u8054\u67e5\u8be2\u53c2\u6570");
            }
            String[] joinKeys = joinKey.split(",");
            if (joinKeys.length != (beJoinedKeys = beJoinedKey.split(",")).length) {
                throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u5173\u8054\u67e5\u8be2\u53c2\u6570");
            }
            for (int j = 0; j < joinKeys.length; ++j) {
                if (StringUtils.isEmpty((CharSequence)joinKeys[j]) || StringUtils.isEmpty((CharSequence)beJoinedKeys[j])) {
                    throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u68c0\u67e5\u5173\u8054\u67e5\u8be2\u53c2\u6570");
                }
                String[] on = new String[]{joinKeys[j], "=", beJoinedKeys[j]};
                ons.add(on);
            }
            String tableName = table;
            if (StringUtil.isNotEmpty((CharSequence)dataBaseName)) {
                tableName = dataBaseName + '.' + table;
            }
            String joinReturnDataType = jsonObject.getString("joinReturnDataType");
            String returnObjName = jsonObject.getString("returnObjName");
            if (StringUtils.isNotEmpty((CharSequence)returnObjName) && variableUtil != null) {
                returnObjName = variableUtil.calVar(content, returnObjName);
            }
            DbEntity joinEntity = DbEntity.create(tableName).addFieldNames(StrUtil.isBlank((CharSequence)columnsJoin) ? null : columnsJoin.split(","));
            ArrayList<JoinQueryField> joinQueryFields = new ArrayList<JoinQueryField>();
            if (StrUtil.isNotBlank((CharSequence)columnsJoin) && !"*".equals(columnsJoin.trim())) {
                Object[] split = columnsJoin.split(",");
                if (ArrayUtil.isNotEmpty((Object[])split)) {
                    for (int j = 0; j < split.length; ++j) {
                        JoinQueryField joinQueryField = new JoinQueryField();
                        if (!((String)split[j]).trim().contains(" ")) {
                            joinQueryField.setOriginalQueryField((String)split[j]);
                            joinQueryField.setAsQueryField(table + "_" + (String)split[j]);
                            split[j] = table + '.' + (String)split[j] + " AS " + table + "_" + (String)split[j];
                        } else {
                            String[] joinQueryFieldSplit;
                            if (((String)split[j]).trim().contains(" as ")) {
                                joinQueryFieldSplit = ((String)split[j]).split(" as ");
                                joinQueryField.setOriginalQueryField(joinQueryFieldSplit[1].trim());
                                joinQueryField.setAsQueryField(joinQueryFieldSplit[1].trim());
                            } else if (((String)split[j]).trim().contains(" AS ")) {
                                joinQueryFieldSplit = ((String)split[j]).split(" AS ");
                                joinQueryField.setOriginalQueryField(joinQueryFieldSplit[1].trim());
                                joinQueryField.setAsQueryField(joinQueryFieldSplit[1].trim());
                            } else {
                                joinQueryField.setOriginalQueryField(((String)split[j]).trim());
                                joinQueryField.setAsQueryField(((String)split[j]).trim());
                            }
                            split[j] = table + '.' + (String)split[j];
                        }
                        joinQueryFields.add(joinQueryField);
                    }
                }
                this.addFieldNames((String[])split);
            }
            if ((queryParamsArray = jsonObject.getJSONArray("queryParamsArray")) != null) {
                ArrayList<ConditionGroup> groupList = new ArrayList<ConditionGroup>();
                int index = 0;
                for (Object object : queryParamsArray) {
                    boolean isFilter;
                    ++index;
                    JSONObject joinJsonObject = (JSONObject)object;
                    String fieldName = joinJsonObject.getString("fieldName");
                    Object fieldValue = joinJsonObject.get((Object)"fieldValue");
                    String symbol = joinJsonObject.getString("symbol");
                    String conditionStr = joinJsonObject.getString("condition");
                    Integer filterType = joinJsonObject.getInteger("filterType");
                    String filterValue = joinJsonObject.getString("filterValue");
                    Boolean isLeft = joinJsonObject.getBoolean("isLeft");
                    if (isLeft == null) {
                        isLeft = false;
                    }
                    if (isLeft.booleanValue()) {
                        ConditionGroup conditionGroup = new ConditionGroup();
                        groupList.add(conditionGroup);
                        continue;
                    }
                    Boolean isRight = joinJsonObject.getBoolean("isRight");
                    if (isRight == null) {
                        isRight = false;
                    }
                    if (isRight.booleanValue()) {
                        ConditionGroup conditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                        groupList.remove((Object)conditionGroup);
                        if (conditionStr == null || LogicalOperator.AND.toString().equalsIgnoreCase(conditionStr)) {
                            conditionGroup.setLinkOperator(LogicalOperator.AND);
                        } else {
                            conditionGroup.setLinkOperator(LogicalOperator.OR);
                        }
                        if (groupList != null && groupList.size() > 0) {
                            ConditionGroup parentConditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                            parentConditionGroup.addConditions(conditionGroup);
                            continue;
                        }
                        joinEntity.set(String.valueOf(index), (Object)conditionGroup);
                        this.set(String.valueOf(index), (Object)conditionGroup);
                        continue;
                    }
                    if (fieldName == null || fieldName.isEmpty() || (isFilter = this.checkFieldValue(fieldName, symbol, fieldValue, filterType, filterValue, content))) continue;
                    Condition condition = this.getCondition(table, fieldName, symbol, fieldValue, conditionStr);
                    if (groupList != null && groupList.size() > 0) {
                        ConditionGroup conditionGroup = (ConditionGroup)((Object)groupList.get(groupList.size() - 1));
                        conditionGroup.addConditions(condition);
                        continue;
                    }
                    joinEntity.set(table + '.' + fieldName, (Object)condition);
                    this.set(table + '.' + fieldName, (Object)condition);
                }
            }
            Join join = Join.of(joinEntity, SqlBuilder.JoinTypeEnum.valueOfString(joinType), ons);
            join.setJoinReturnDataType(joinReturnDataType);
            join.setJoinReturnObjName(returnObjName);
            join.setJoinQueryFields(joinQueryFields);
            joins.add(join);
        }
        return joins;
    }

    public SqlBuilder.InsertTypeEnum getInsertTypeEnum() {
        return this.insertTypeEnum;
    }

    public DbEntity setInsertTypeEnum(SqlBuilder.InsertTypeEnum insertTypeEnum) {
        this.insertTypeEnum = insertTypeEnum;
        return this;
    }

    public String getPk() {
        return this.pk;
    }

    public DbEntity setPk(String pk) {
        this.pk = pk;
        return this;
    }

    public Collection<Join> getJoins() {
        return this.joins;
    }

    public DbEntity setJoins(Collection<Join> joins) {
        this.joins = joins;
        return this;
    }

    public boolean getGetOne() {
        return this.getOne;
    }

    public DbEntity setGetOne(boolean getOne) {
        this.getOne = getOne;
        return this;
    }

    public boolean isOnlyOperator(String operator) {
        return "IS NULL".equalsIgnoreCase(operator) || "IS NOT NULL".equalsIgnoreCase(operator);
    }

    public DbEntity clone() {
        return (DbEntity)super.clone();
    }

    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }

    private boolean checkFieldValue(String fieldName, String symbol, Object filedValue, Integer filterType, String filterValue, ProcessContent content) {
        if (filterType == null) {
            filterType = 2;
        }
        boolean isFilter = false;
        switch (filterType) {
            case 1: {
                isFilter = false;
                break;
            }
            case 2: {
                if (filedValue != null) break;
                isFilter = true;
                break;
            }
            case 3: {
                if (filedValue == null) {
                    isFilter = true;
                }
                if (!(filedValue instanceof String) || !StringUtils.isEmpty((CharSequence)((String)filedValue))) break;
                isFilter = true;
                break;
            }
            case 4: {
                Set filedValueList;
                if (filedValue == null) {
                    isFilter = true;
                }
                if (filedValue instanceof List || filedValue instanceof JSONArray) {
                    List filedValueList2 = (List)filedValue;
                    if (filedValueList2 != null && filedValueList2.size() > 0) break;
                    isFilter = true;
                    break;
                }
                if (!(filedValue instanceof Set) || (filedValueList = (Set)filedValue) != null && filedValueList.size() > 0) break;
                isFilter = true;
                break;
            }
            case 5: {
                HashMap<String, Object> paramsKeyValue = new HashMap<String, Object>();
                paramsKeyValue.put(fieldName, filedValue);
                CheckContent checkContent = new CheckContent();
                HashMap<String, Object> temp = new HashMap<String, Object>();
                if (content != null) {
                    checkContent.setRequest(content.getRequest());
                    if (content.getTemp() != null) {
                        temp.putAll(content.getTemp());
                    }
                }
                temp.putAll(paramsKeyValue);
                checkContent.setTemp(temp);
                checkContent.setParamsKeyValue(paramsKeyValue);
                checkContent.setParams(fieldName);
                checkContent.setExpression(filterValue);
                JSONObject module = new JSONObject();
                module.put("systemVersion", (Object)"2.4");
                checkContent.setModule(module);
                CheckUtil checkUtil = (CheckUtil)SpringContextManager.getBean(CheckUtil.class);
                ICheck check = checkUtil.getCheck("expression_v2");
                check.doCheck(checkContent);
                if (!checkContent.isSuccess()) break;
                isFilter = true;
                break;
            }
        }
        return isFilter;
    }

    private Condition getCondition(String tableName, String fieldName, String symbol, Object fieldValue, String conditionStr) {
        Condition condition;
        if (Condition.LikeType.Contains.toString().equalsIgnoreCase(symbol) || "like".equalsIgnoreCase(symbol)) {
            condition = new Condition(tableName + '.' + fieldName, fieldValue == null ? null : fieldValue.toString(), Condition.LikeType.Contains);
        } else if (Condition.LikeType.StartWith.toString().equalsIgnoreCase(symbol)) {
            condition = new Condition(tableName + '.' + fieldName, fieldValue == null ? null : fieldValue.toString(), Condition.LikeType.StartWith);
        } else if (Condition.LikeType.EndWith.toString().equalsIgnoreCase(symbol)) {
            condition = new Condition(tableName + '.' + fieldName, fieldValue == null ? null : fieldValue.toString(), Condition.LikeType.EndWith);
        } else if ("in".equalsIgnoreCase(symbol)) {
            if (fieldValue != null && fieldValue instanceof List) {
                List valueList = fieldValue;
                fieldValue = valueList.stream().distinct().collect(Collectors.toList());
            }
            condition = new Condition(tableName + '.' + fieldName, symbol, fieldValue);
        } else if ("not in".equalsIgnoreCase(symbol)) {
            if (fieldValue != null && fieldValue instanceof List) {
                List valueList = fieldValue;
                fieldValue = valueList.stream().distinct().collect(Collectors.toList());
            }
            condition = new Condition(tableName + '.' + fieldName, symbol, fieldValue);
        } else {
            condition = Condition.NotLikeType.Does_Not_Contain.getSymbol().equalsIgnoreCase(symbol) || "NOT LIKE".equalsIgnoreCase(symbol) ? new Condition(tableName + '.' + fieldName, fieldValue.toString(), Condition.NotLikeType.Does_Not_Contain) : (Condition.NotLikeType.Does_Not_StartWith.getSymbol().equalsIgnoreCase(symbol) ? new Condition(tableName + '.' + fieldName, fieldValue.toString(), Condition.NotLikeType.Does_Not_StartWith) : (Condition.NotLikeType.Does_Not_EndWith.getSymbol().equalsIgnoreCase(symbol) ? new Condition(tableName + '.' + fieldName, fieldValue.toString(), Condition.NotLikeType.Does_Not_EndWith) : ("IS NULL".equalsIgnoreCase(symbol) ? new Condition(tableName + '.' + fieldName, "IS NULL") : ("IS NOT NULL".equalsIgnoreCase(symbol) ? new Condition(tableName + '.' + fieldName, "IS NOT NULL") : new Condition(tableName + '.' + fieldName, symbol, fieldValue)))));
        }
        if (conditionStr == null || LogicalOperator.AND.toString().equalsIgnoreCase(conditionStr)) {
            condition.setLinkOperator(LogicalOperator.AND);
        } else {
            condition.setLinkOperator(LogicalOperator.OR);
        }
        return condition;
    }
}

