/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBInsert;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.In;
import com.manatee.common.domain.Page;
import com.manatee.common.domain.StrSplit;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.MapUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.map.MapUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class DBHandle {
    private static final Logger log = LoggerFactory.getLogger(DBHandle.class);
    private final String INDEX = "index";

    public abstract String getName();

    public PreparedStatement getPreparedStatement(Connection con, StringBuilder sqlSB) throws SQLException {
        return con.prepareStatement(sqlSB.toString(), 1);
    }

    public StringBuilder initColumnsSql(StringBuilder sqlSB, DBQuery dbQuery) {
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            sqlSB = sqlSB.append(dbQuery.getColumns());
        }
        return sqlSB;
    }

    public StringBuilder initAppendTableSql(StringBuilder sqlSB, String table, Connection con) {
        sqlSB.append(table);
        return sqlSB;
    }

    public int executeInsert(PreparedStatement ps, DBInsert insert) throws SQLException {
        return ps.executeUpdate();
    }

    public StringBuilder initJoinSql(StringBuilder sqlSB, DBQuery dbQuery, Connection con) {
        int i;
        if (CollectionUtil.isEmpty((Collection)dbQuery.getJoin())) {
            return sqlSB;
        }
        sqlSB = new StringBuilder("select ");
        String tableAlias = dbQuery.getTable();
        ArrayList<String> fieldNameList = new ArrayList<String>();
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            String[] fields = dbQuery.getColumns().split(",");
            for (int i2 = 0; i2 < fields.length; ++i2) {
                fieldNameList.add(tableAlias + "." + fields[i2]);
            }
        } else {
            fieldNameList.add(tableAlias + ".*");
        }
        JSONArray joinArray = dbQuery.getJoin();
        StringBuilder joinSb = new StringBuilder();
        if (joinArray != null) {
            for (i = 0; i < joinArray.size(); ++i) {
                JSONObject joinConf = joinArray.getJSONObject(i);
                StringBuilder rightTableSelectSb = new StringBuilder(joinConf.getString("table"));
                String rightTable = joinConf.getString("table");
                JSONObject joinQueryParams = joinConf.getJSONObject("queryParams");
                if (MapUtil.isNotEmpty((Map)joinQueryParams)) {
                    rightTableSelectSb = new StringBuilder("(select * from " + rightTable + " where ");
                    String joinCondition = joinQueryParams.getString("condition");
                    if (StrUtil.isNotEmpty((CharSequence)joinCondition)) {
                        rightTableSelectSb.append(joinCondition).append(" and ");
                        joinQueryParams.remove((Object)"condition");
                    }
                    for (Map.Entry aMap : joinQueryParams.entrySet()) {
                        Object value = aMap.getValue();
                        if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                        rightTableSelectSb.append((String)aMap.getKey()).append("=?").append(" and ");
                    }
                    if (rightTableSelectSb.substring(rightTableSelectSb.length() - 5).equals(" and ")) {
                        rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 5));
                    }
                    if (rightTableSelectSb.substring(rightTableSelectSb.length() - 7).equals(" where ")) {
                        rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 7));
                    }
                    rightTableSelectSb.append(")");
                }
                String joinKey = joinConf.getString("joinKey");
                String beJoinedKey = joinConf.getString("beJoinedKey");
                String joinType = joinConf.getString("joinType");
                if (StrUtil.isNotEmpty((CharSequence)joinType)) {
                    joinSb.append(" " + joinType + " ");
                } else {
                    joinSb.append(" JOIN ");
                }
                joinSb.append(rightTableSelectSb.toString()).append(" ").append(rightTable).append(" ON ").append(tableAlias).append(".").append(joinKey).append(" = ").append(rightTable).append(".").append(beJoinedKey);
                String rightTableColumns = joinConf.getString("columns");
                if (!StrUtil.isNotEmpty((CharSequence)rightTableColumns)) continue;
                String[] rightTableFields = rightTableColumns.split(",");
                for (int j = 0; j < rightTableFields.length; ++j) {
                    String[] rtfnArr = rightTableFields[j].trim().split(" ");
                    String rightTableFieldName = rtfnArr.length <= 1 ? rightTable + "_" + rightTableFields[j] : rightTableFields[j].replaceFirst(rtfnArr[0], "");
                    fieldNameList.add(rightTable + "." + rtfnArr[0] + " " + rightTableFieldName);
                }
            }
        }
        for (i = 0; i < fieldNameList.size(); ++i) {
            sqlSB = sqlSB.append((String)fieldNameList.get(i));
            if (i >= fieldNameList.size() - 1) continue;
            sqlSB = sqlSB.append(",");
        }
        sqlSB.append(" from " + dbQuery.getTable()).append(" ").append(tableAlias);
        sqlSB.append((CharSequence)joinSb);
        this.handleFieldPrefixForJoin(dbQuery);
        return sqlSB;
    }

    public StringBuilder initConditionMapSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Map conditionMap = dbQuery.getConditionMap();
        if (conditionMap != null && conditionMap.size() != 0) {
            sqlSB.append(" where ");
            for (Map.Entry aMap : conditionMap.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                sqlSB.append((String)aMap.getKey()).append("=?").append(" and ");
            }
            if (sqlSB.substring(sqlSB.length() - 5).equals(" and ")) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 5));
            }
            if (sqlSB.substring(sqlSB.length() - 7).equals(" where ")) {
                sqlSB = new StringBuilder(sqlSB.substring(0, sqlSB.length() - 7));
            }
        }
        return sqlSB;
    }

    public StringBuilder initConditionSql(StringBuilder sqlSB, DBQuery dbQuery) {
        String conditionSql = dbQuery.getCondition();
        if (StringUtil.isBlank((String)conditionSql)) {
            return sqlSB;
        }
        if (sqlSB.indexOf("where") == -1) {
            sqlSB.append(" where ");
        } else {
            sqlSB.append(" and ");
        }
        sqlSB.append(conditionSql);
        return sqlSB;
    }

    public StringBuilder initInSql(StringBuilder sqlSB, DBQuery dbQuery) {
        List inList = dbQuery.getIn();
        if (inList == null || inList.size() == 0) {
            return sqlSB;
        }
        StringBuilder inCondition = new StringBuilder();
        for (In in : inList) {
            if (in == null) {
                return sqlSB;
            }
            List list = in.getValue();
            String key = in.getKey();
            boolean filterEmptyInValue = in.isFilterEmptyValue();
            if (StringUtil.isBlank((String)key)) {
                return sqlSB;
            }
            if (CollectionUtil.isEmpty((Collection)list) && filterEmptyInValue) continue;
            inCondition.append(key);
            inCondition.append(" in (");
            for (Object value : list) {
                if (value == null) continue;
                inCondition.append("?,");
            }
            String str = inCondition.substring(0, inCondition.toString().endsWith(",") ? inCondition.length() - 1 : inCondition.length());
            inCondition = new StringBuilder(str);
            inCondition.append(") and ");
        }
        if (inCondition != null && !"".equals(inCondition) && inCondition.toString().endsWith(" and ")) {
            if (sqlSB.indexOf("where") == -1) {
                sqlSB.append(" where ");
            } else {
                sqlSB.append(" and ");
            }
            StringBuilder result = new StringBuilder(inCondition.substring(0, inCondition.length() - 5));
            return sqlSB.append((CharSequence)result);
        }
        return sqlSB;
    }

    public StringBuilder initSortSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Map sortMap = dbQuery.getSort();
        if (sortMap != null && sortMap.size() > 0) {
            sqlSB.append(" order by ");
            for (String sortKey : sortMap.keySet()) {
                sqlSB.append(sortKey).append(" ").append(sortMap.get(sortKey)).append(", ");
            }
            sqlSB.deleteCharAt(sqlSB.lastIndexOf(","));
        }
        return sqlSB;
    }

    public StringBuilder initPageSql(StringBuilder sqlSB, DBQuery dbQuery) {
        Page page = dbQuery.getPage();
        if (page == null) {
            return sqlSB;
        }
        Integer pageNum = page.getPageNum();
        Integer pageSize = page.getPageSize();
        Integer skip = null;
        if (pageNum != null && pageSize != null) {
            skip = (pageNum - 1) * pageSize;
        }
        if (skip != null && pageSize != null) {
            sqlSB.append(" limit ").append(skip).append(", ").append(pageSize);
        } else if (pageSize != null) {
            sqlSB.append(" limit ").append(pageSize);
        }
        return sqlSB;
    }

    public void initJoinParam(StringBuilder sqlSb, DBQuery dbQuery, PreparedStatement ps) throws SQLException {
        JSONArray joinArray = dbQuery.getJoin();
        int index = 1;
        if (joinArray != null && joinArray.size() != 0) {
            for (int i = 0; i < joinArray.size(); ++i) {
                JSONObject joinConf = joinArray.getJSONObject(i);
                JSONObject joinQueryParams = joinConf.getJSONObject("queryParams");
                index = this.getIndex(sqlSb, ps, index, joinQueryParams);
            }
        }
        dbQuery.putTemp("index", (Object)index);
    }

    public void initCascadeParam(StringBuilder sqlSb, DBQuery dbQuery, PreparedStatement ps) throws SQLException {
        JSONArray cascadeArray = dbQuery.getCascade();
        int index = 1;
        if (cascadeArray != null && cascadeArray.size() != 0) {
            for (int i = 0; i < cascadeArray.size(); ++i) {
                JSONObject joinConf = cascadeArray.getJSONObject(i);
                JSONObject joinQueryParams = joinConf.getJSONObject("queryParams");
                index = this.getIndex(sqlSb, ps, index, joinQueryParams);
            }
        }
        dbQuery.putTemp("index", (Object)index);
    }

    private int getIndex(StringBuilder sqlSb, PreparedStatement ps, int index, JSONObject joinQueryParams) throws SQLException {
        if (MapUtil.isNotEmpty((Map)joinQueryParams)) {
            for (Map.Entry aMap : joinQueryParams.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                this.initParamInPS(sqlSb, ps, index, value);
                ++index;
            }
        }
        return index;
    }

    public void initConditionParam(StringBuilder sqlSb, DBQuery dbQuery, PreparedStatement ps) throws SQLException {
        Map condition = dbQuery.getConditionMap();
        Integer index = (Integer)dbQuery.getTemp("index");
        if (condition != null && condition.size() != 0) {
            for (Map.Entry aMap : condition.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                this.initParamInPS(sqlSb, ps, index, value);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        dbQuery.putTemp("index", (Object)index);
    }

    public void initInParam(StringBuilder sqlSb, DBQuery dbQuery, PreparedStatement ps) throws SQLException {
        List inList = dbQuery.getIn();
        if (inList == null || inList.size() == 0) {
            return;
        }
        for (In in : inList) {
            List list = in.getValue();
            String key = in.getKey();
            if (list == null || key == null) {
                return;
            }
            Integer index = (Integer)dbQuery.getTemp("index");
            for (Object value : list) {
                if (value == null) continue;
                this.initParamInPS(sqlSb, ps, index, value);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            dbQuery.putTemp("index", (Object)index);
        }
    }

    public StringBuilder initInsertConditionSql(DBInsert insert, Connection con) throws SQLException {
        String insertType = insert.getInsertType();
        StringBuilder paramSb = new StringBuilder();
        StringBuilder sqlSb = new StringBuilder();
        if (StringUtils.isBlank((String)insertType) || "error".equalsIgnoreCase(insertType)) {
            sqlSb.append("insert");
            paramSb.append(" into ");
        } else if ("ignore".equalsIgnoreCase(insertType)) {
            sqlSb.append("insert");
            paramSb.append(" ignore into ");
        } else if ("replace".equalsIgnoreCase(insertType)) {
            paramSb.append(" replace into ");
        }
        paramSb.append("`" + insert.getTable() + "`");
        paramSb.append(" (");
        Map insertColumns = insert.getInsertColumns();
        if (insertColumns == null) {
            List list = insert.getInsertColumnsBatch();
            insertColumns = (Map)list.get(0);
        }
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry aMap : insertColumns.entrySet()) {
            Object value;
            if (!insert.isBatch() && (value = aMap.getValue()) == null) continue;
            paramSb.append((String)aMap.getKey()).append(StrSplit.D);
            valueSb.append("?,");
        }
        String params = paramSb.substring(0, paramSb.length() - 1);
        String value = valueSb.substring(0, valueSb.length() - 1);
        StringBuilder paramAndValueSb = new StringBuilder(params);
        paramAndValueSb = paramAndValueSb.append(") values ");
        valueSb = new StringBuilder();
        valueSb.append("(").append(value).append("),");
        if (insert.isBatch()) {
            String valuesSql = valueSb.toString();
            List insertBatchColumns = insert.getInsertColumnsBatch();
            for (int i = 1; i < insertBatchColumns.size(); ++i) {
                valueSb = valueSb.append(valuesSql);
            }
        }
        paramAndValueSb = paramAndValueSb.append(valueSb.substring(0, valueSb.length() - 1));
        sqlSb = sqlSb.append((CharSequence)paramAndValueSb);
        return sqlSb;
    }

    public StringBuilder initSelectOneLimitSql(StringBuilder sqlSB, DBQuery dbQuery) {
        if (dbQuery.getSelectOne().booleanValue()) {
            sqlSB.append(" limit 1");
        }
        return sqlSB;
    }

    public void handleInsertResult(DBInsert insert, Connection con, PreparedStatement ps, JSONObject result, int insertNum) {
        block11: {
            if (!insert.isBatch()) {
                try {
                    String pkName = insert.getPkName();
                    if (StringUtil.isNotBlank((String)pkName)) {
                        ResultSet rs = ps.getGeneratedKeys();
                        if (rs.next()) {
                            Object pkNum = rs.getObject(1);
                            result.put("pkNum", pkNum);
                        } else {
                            Map insertColumns = insert.getInsertColumns();
                            if (insertColumns != null) {
                                result.put("pkNum", insertColumns.get(pkName));
                            }
                        }
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            break block11;
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                    result.put("count", (Object)insertNum);
                }
                catch (Throwable e) {
                    log.error("[DBWriteBase.insert]_exception", e);
                }
            } else {
                result.put("count", (Object)insertNum);
            }
        }
    }

    public void composeInsertResult(DBInsert insert, ProcessContent content, JSONObject insertResult, IOutputUtil outputUtil) throws BizException {
        if (insert.isBatch()) {
            outputUtil.setDefaultReturnKey(content, "count");
            outputUtil.putData(content, insertResult.get((Object)"count"));
        } else {
            Object pkNum = insertResult.get((Object)"pkNum");
            if (pkNum != null && StringUtil.isNotBlank((String)pkNum.toString())) {
                outputUtil.setDefaultReturnKey(content, insert.getPkName());
                outputUtil.putData(content, pkNum);
            } else {
                outputUtil.setDefaultReturnKey(content, "count");
                outputUtil.putData(content, insertResult.get((Object)"count"));
            }
        }
    }

    public StringBuilder initSchemaSql(Connection con, StringBuilder sqlSb, String schema) throws SQLException {
        sqlSb.append("SELECT t.TABLE_SCHEMA FROM information_schema.TABLES t WHERE 1 = 1 ");
        if (StringUtil.isNotBlank((String)schema)) {
            sqlSb.append("AND t.TABLE_SCHEMA LIKE ").append("'%").append(schema).append("%' ");
        }
        sqlSb.append("GROUP BY t.TABLE_SCHEMA ");
        return sqlSb;
    }

    public StringBuilder initTablesSql(Connection con, StringBuilder sqlSb, String table, String schema) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = con.getCatalog();
        }
        sqlSb.append("SELECT a.TABLE_NAME, a.COLUMN_NAME FROM information_schema.COLUMNS a RIGHT JOIN ( SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = '");
        sqlSb.append(schema).append("'");
        if (StringUtil.isNotBlank((String)table)) {
            sqlSb.append("AND TABLE_NAME LIKE ").append("'%").append(table).append("%'");
        }
        sqlSb.append("GROUP BY TABLE_NAME LIMIT 0, 10 ) b ON a.TABLE_NAME = b.TABLE_NAME  WHERE a.TABLE_SCHEMA = '").append(schema).append("' ");
        sqlSb.append("ORDER BY a.ORDINAL_POSITION ");
        return sqlSb;
    }

    public StringBuilder initTableNameListSql(Connection con, StringBuilder sqlSb, List<String> tableNameList, String schema) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = con.getCatalog();
        }
        sqlSb.append("SELECT a.TABLE_NAME, a.COLUMN_NAME FROM information_schema.COLUMNS a RIGHT JOIN ( SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = '");
        sqlSb.append(schema).append("' AND TABLE_NAME IN (");
        for (int i = 0; i < tableNameList.size(); ++i) {
            sqlSb.append("'").append(tableNameList.get(i)).append("'");
            if (i >= tableNameList.size() - 1) continue;
            sqlSb.append(",");
        }
        sqlSb.append(") GROUP BY TABLE_NAME ) b ON a.TABLE_NAME = b.TABLE_NAME  WHERE a.TABLE_SCHEMA = '").append(schema).append("'");
        return sqlSb;
    }

    public void handleFieldPrefixForJoin(DBQuery dbQuery) {
        Map sort;
        List inList;
        String condition;
        String tableAlias = dbQuery.getTable();
        Map conditionMap = dbQuery.getConditionMap();
        if (MapUtil.isNotEmpty((Map)conditionMap)) {
            HashMap conditionMapJoin = new HashMap();
            for (String key : conditionMap.keySet()) {
                Object value = conditionMap.get(key);
                conditionMapJoin.put(tableAlias + "." + key, value);
            }
            dbQuery.setConditionMap(conditionMapJoin);
        }
        if (StrUtil.isNotEmpty((CharSequence)(condition = dbQuery.getCondition()))) {
            StringBuilder fieldConditionSb = new StringBuilder();
            String[] andArr = condition.split(" and ");
            for (int k = 0; k < andArr.length; ++k) {
                String[] orArr = ((String)andArr[k]).split(" or ");
                for (int j = 0; j < orArr.length; ++j) {
                    fieldConditionSb.append(" ").append(tableAlias).append(".").append(orArr[j]);
                    if (j >= orArr.length - 1) continue;
                    fieldConditionSb = fieldConditionSb.append(" ").append("or");
                }
                if (k >= andArr.length - 1) continue;
                fieldConditionSb = fieldConditionSb.append(" ").append("and");
            }
            String conditionJoin = fieldConditionSb.toString();
            dbQuery.setCondition(conditionJoin);
        }
        if (ArrayUtil.isNotEmpty((Object)(inList = dbQuery.getIn()))) {
            for (In in : inList) {
                in.setKey(tableAlias + "." + in.getKey());
            }
        }
        if (MapUtil.isNotEmpty((Map)(sort = dbQuery.getSort()))) {
            HashMap sortJoin = new HashMap();
            for (String key : sort.keySet()) {
                sortJoin.put(tableAlias + "." + key, sort.get(key));
            }
            dbQuery.setSort(sortJoin);
        }
    }

    private void initParamInPS(StringBuilder sqlSb, PreparedStatement ps, int index, Object value) throws SQLException {
        if (value instanceof Integer) {
            ps.setInt(index, (Integer)value);
        } else if (value instanceof Long) {
            ps.setLong(index, (Long)value);
        } else {
            ps.setString(index, value + "");
        }
        String sql = sqlSb.toString().replaceFirst("\\?", value instanceof String ? "'" + value + "'" : Matcher.quoteReplacement(JSONObject.toJSONString((Object)value)));
        sqlSb.delete(0, sqlSb.length());
        sqlSb.append(sql);
    }

    public void initCountSql(String from, DBQuery dbQueryForCount) {
        from = from.substring(0, from.lastIndexOf("limit"));
        dbQueryForCount.setSql("select count(*) from (" + from + ") count_table");
    }

    public Map<String, Object> initParamsSql(Map<String, Object> params, String dbName, String tableName) {
        return params;
    }

    public List<Map<String, Object>> initListParamsSql(List<Map<String, Object>> listParams, String dbName, String tableName) {
        return listParams;
    }

    public JSONArray initInSql(JSONArray jsonArray, String dbName, String tableName) {
        return jsonArray;
    }

    public ResultSet cascadeQuery(DBQuery dbQuery, Connection con, PreparedStatement ps, JSON data, JSONObject cascadeConf) throws SQLException {
        String table = cascadeConf.getString("table");
        if (StringUtil.isBlank((String)table)) {
            throw new SQLException("\u7ea7\u8054\u67e5\u8be2\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cascadeKey = cascadeConf.getString("cascadeKey");
        cascadeKey = this.getCascadeKey(dbQuery, cascadeKey);
        StringBuilder cascadeKeyParams = new StringBuilder();
        if (data instanceof List || data instanceof JSONArray) {
            List list = (List)data;
            for (Object dataObj : list) {
                Map dataMap = (Map)dataObj;
                Object cascadeKeyObj = dataMap.get(cascadeKey);
                if (cascadeKeyObj == null || "".equals(cascadeKeyObj)) continue;
                cascadeKeyParams.append("'").append(cascadeKeyObj).append("'").append(StrSplit.D);
            }
        } else {
            Map dataMap = (Map)data;
            Object cascadeKeyObj = dataMap.get(cascadeKey);
            if (cascadeKeyObj != null && !"".equals(cascadeKeyObj)) {
                cascadeKeyParams.append(cascadeKeyObj).append(StrSplit.D);
            }
        }
        if (StringUtil.isBlank((String)cascadeKeyParams.toString())) {
            throw new SQLException("\u7ea7\u8054\u67e5\u8be2\u8868key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String cascadeKeySql = cascadeKeyParams.substring(0, cascadeKeyParams.length() - 1);
        String beCascadeedKey = cascadeConf.getString("beCascadeedKey");
        StringBuilder cascadeKeyStr = new StringBuilder(beCascadeedKey);
        String columns = cascadeConf.getString("columns");
        StringBuilder sql = new StringBuilder("select ");
        if (StringUtil.isBlank((String)columns)) {
            columns = "*";
        }
        sql.append(columns).append(StrSplit.D).append((CharSequence)cascadeKeyStr).append(" from ").append(table).append(" where ");
        cascadeKeyStr.append(StrSplit.KG).append("in").append(StrSplit.KG).append("(");
        sql.append((CharSequence)cascadeKeyStr).append(cascadeKeySql).append(")");
        JSONObject cascadeQueryParams = cascadeConf.getJSONObject("queryParams");
        if (MapUtils.isNotEmpty((Map)cascadeQueryParams)) {
            StringBuilder rightTableSelectSb = new StringBuilder("and (");
            String joinCondition = cascadeQueryParams.getString("condition");
            if (StringUtil.isNotEmpty((CharSequence)joinCondition)) {
                rightTableSelectSb.append(joinCondition).append(" and ");
                cascadeQueryParams.remove((Object)"condition");
            }
            for (Map.Entry aMap : cascadeQueryParams.entrySet()) {
                Object value = aMap.getValue();
                if (value == null || StringUtil.isBlank((String)value.toString())) continue;
                rightTableSelectSb.append((String)aMap.getKey()).append("=?").append(" and ");
            }
            if (rightTableSelectSb.substring(rightTableSelectSb.length() - 5).equals(" and ")) {
                rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 5));
            }
            if (rightTableSelectSb.substring(rightTableSelectSb.length() - 7).equals(" where ")) {
                rightTableSelectSb = new StringBuilder(rightTableSelectSb.substring(0, rightTableSelectSb.length() - 7));
            }
            rightTableSelectSb.append(")");
            sql.append((CharSequence)rightTableSelectSb);
        }
        ps = con.prepareStatement(sql.toString());
        this.initCascadeParam(sql, dbQuery, ps);
        log.info(" sql : {}", (Object)sql.toString());
        return ps.executeQuery();
    }

    private String getCascadeKey(DBQuery dbQuery, String cascadeKey) {
        Boolean camelCase;
        String upperOrLowerCase = dbQuery.getUpperOrLowerCase();
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "upperCase".equals(upperOrLowerCase)) {
            cascadeKey = cascadeKey.toUpperCase();
        }
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "lowerCase".equals(upperOrLowerCase)) {
            cascadeKey = cascadeKey.toLowerCase();
        }
        if ((camelCase = dbQuery.getCamelCase()).booleanValue() && cascadeKey.indexOf("_") != -1) {
            cascadeKey = this.camelCase(cascadeKey.toLowerCase());
            return cascadeKey;
        }
        return cascadeKey;
    }

    public String camelCase(String columnName) {
        String[] arr = columnName.split("_");
        if (arr.length > 1) {
            StringBuilder columnNameSb = new StringBuilder(arr[0]);
            for (int index = 1; index < arr.length; ++index) {
                String firstChar = arr[index].charAt(0) + "";
                columnNameSb.append(firstChar.toUpperCase() + arr[index].substring(1));
            }
            columnName = columnNameSb.toString();
        }
        return columnName;
    }

    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getCatalogs(conn);
    }

    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getCatalog();
        }
        return MetaUtil.getTablesBySchema(conn, schema, null, tableName);
    }

    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable(conn, schema, null, tableName);
    }
}

