/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.connector;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.connector.ManateeConnector;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class HikariDataSourceConnector
extends ManateeConnector {
    private static final Logger log = LoggerFactory.getLogger(HikariDataSourceConnector.class);

    @Override
    public DataSource createDataSource(DataSourceProperties dataSourceProperties) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setUsername(dataSourceProperties.getUsername());
        hikariConfig.setPassword(dataSourceProperties.getPassword());
        hikariConfig.setJdbcUrl(dataSourceProperties.getUrl());
        if (StringUtil.isNotBlank((String)dataSourceProperties.getDriverClassName())) {
            hikariConfig.setDriverClassName(dataSourceProperties.getDriverClassName());
        }
        hikariConfig.setMaximumPoolSize(10);
        hikariConfig.setMinimumIdle(10);
        return new HikariDataSource(hikariConfig);
    }

    @Override
    public void addDataSource(JSONObject dbJson) {
        Integer minimumIdle;
        String url;
        String password;
        String name = dbJson.getString("name");
        assert (StringUtil.isNotBlank((String)name));
        String username = dbJson.getString("username");
        if (HikariDataSourceConnector.isDbAlreadyExist(name, username, password = dbJson.getString("password"), url = dbJson.getString("url")).booleanValue()) {
            log.info("[ManateeDataSourceManager.addDd]_warn: " + name + " \u6570\u636e\u6e90\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
            return;
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.setJdbcUrl(url);
        Integer maximumPoolSize = dbJson.getInteger("maximumPoolSize");
        if (maximumPoolSize != null) {
            hikariConfig.setMaximumPoolSize(maximumPoolSize.intValue());
        }
        if ((minimumIdle = dbJson.getInteger("minimumIdle")) != null) {
            hikariConfig.setMinimumIdle(minimumIdle.intValue());
        }
        log.warn("[ManateeDataSourceManager.addDd]_warn: " + name + " \u52a8\u6001\u6570\u636e\u6e90\u6dfb\u52a0\u6210\u529f");
        ManateeDataSource.addDataSource(name, (DataSource)new HikariDataSource(hikariConfig));
    }

    private static Boolean isDbAlreadyExist(String name, String username, String password, String url) {
        if ("default".equals(name)) {
            throw new RuntimeException("\u9ed8\u8ba4\u4e3b\u6570\u636e\u6e90\u4e0d\u53ef\u8986\u76d6\u548c\u6dfb\u52a0");
        }
        if (ManateeDataSource.getDataSourceNameSet().contains(name)) {
            HikariDataSource oldDataSource = (HikariDataSource)ManateeDataSource.dataSourceMap.get(name);
            StringBuilder oldDataSourceSb = new StringBuilder();
            oldDataSourceSb.append(oldDataSource.getJdbcUrl()).append(oldDataSource.getUsername()).append(oldDataSource.getPassword());
            StringBuilder newDataSourceSb = new StringBuilder();
            newDataSourceSb.append(url).append(username).append(password);
            if (oldDataSourceSb.toString().equals(newDataSourceSb.toString())) {
                return true;
            }
            return false;
        }
        return false;
    }
}

