/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.DateUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.handle.DBHandleUtil;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.ProjectConfUtil;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DBReadBase {
    @Value(value="${default-db-field-lower-case:false}")
    private Boolean defaultDBFieldLowerCase;
    private Logger log = LoggerFactory.getLogger(DBReadBase.class);
    @Resource
    protected ManateeDataSource manateeDataSource;
    @Resource
    private DBHandleUtil dbHandleUtil;
    private String INDEX = "index";

    protected ResultSet executeSelectSql(String sql, Connection con, PreparedStatement ps) throws SQLException {
        ps = con.prepareStatement(sql);
        return ps.executeQuery();
    }

    protected int executeNotSelectSql(String sql, Connection con, PreparedStatement ps) throws SQLException, BizException {
        ps = con.prepareStatement(sql);
        return ps.executeUpdate();
    }

    protected ResultSet getSelect(DBQuery dbQuery, Connection con, PreparedStatement ps) throws SQLException {
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbQuery.getDatabaseProductName());
        if (dbHandle == null) {
            return null;
        }
        StringBuilder sqlSB = new StringBuilder("select ");
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            sqlSB = dbHandle.initColumnsSql(sqlSB, dbQuery);
        } else {
            sqlSB.append("*");
        }
        sqlSB.append(" from ");
        sqlSB = dbHandle.initAppendTableSql(sqlSB, dbQuery.getTable(), con);
        sqlSB = dbHandle.initJoinSql(sqlSB, dbQuery, con);
        sqlSB = dbHandle.initConditionMapSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initConditionSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initInSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initSortSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initPageSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initSelectOneLimitSql(sqlSB, dbQuery);
        ps = con.prepareStatement(sqlSB.toString());
        StringBuilder executeSqlSb = new StringBuilder(sqlSB);
        dbHandle.initJoinParam(executeSqlSb, dbQuery, ps);
        dbHandle.initConditionParam(executeSqlSb, dbQuery, ps);
        dbHandle.initInParam(executeSqlSb, dbQuery, ps);
        dbQuery.setExecuteSql(executeSqlSb.toString());
        return ps.executeQuery();
    }

    protected ResultSet getSelectTotalCount(DBQuery dbQuery, Connection con, PreparedStatement ps) throws SQLException {
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbQuery.getDatabaseProductName());
        if (dbHandle == null) {
            return null;
        }
        StringBuilder sqlSB = new StringBuilder("select count(*) ");
        sqlSB.append(" from ");
        sqlSB = dbHandle.initAppendTableSql(sqlSB, dbQuery.getTable(), con);
        sqlSB = dbHandle.initJoinSql(sqlSB, dbQuery, con);
        sqlSB = dbHandle.initConditionMapSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initConditionSql(sqlSB, dbQuery);
        sqlSB = dbHandle.initInSql(sqlSB, dbQuery);
        String[] sqlArr = sqlSB.toString().split(" from ");
        sqlSB = new StringBuilder("select count(*) from " + sqlSB.toString().split(" from ")[1]);
        if (sqlArr.length > 2) {
            for (int i = 2; i < sqlArr.length; ++i) {
                sqlSB.append(" from ").append(sqlArr[i]);
            }
        }
        ps = con.prepareStatement(sqlSB.toString());
        StringBuilder executeSqlSb = new StringBuilder(sqlSB);
        dbHandle.initJoinParam(executeSqlSb, dbQuery, ps);
        dbHandle.initConditionParam(executeSqlSb, dbQuery, ps);
        dbHandle.initInParam(executeSqlSb, dbQuery, ps);
        dbQuery.setExecuteSql(executeSqlSb.toString());
        return ps.executeQuery();
    }

    protected ResultSet cascadeQuery(DBQuery dbQuery, Connection con, PreparedStatement ps, JSON data, JSONObject cascadeConf) throws SQLException {
        DBHandle dbHandle = this.dbHandleUtil.getDBHandle(dbQuery.getDatabaseProductName());
        if (dbHandle == null) {
            return null;
        }
        ResultSet resultSet = dbHandle.cascadeQuery(dbQuery, con, ps, data, cascadeConf);
        return resultSet;
    }

    public Map<String, Object> convertMap(ResultSet rs, DBQuery dbQuery, ProcessContent content) throws SQLException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            Object obj = rs.getObject(i);
            obj = this.handleColumnValueType(obj, rs, i, md);
            String columnName = md.getColumnLabel(i);
            columnName = this.handleColumnName(columnName, dbQuery, content);
            map.put(columnName, obj);
        }
        return map;
    }

    public Map<String, Object> convertMap(ResultSet rs, DBQuery dbQuery) throws SQLException {
        return this.convertMap(rs, dbQuery, null);
    }

    private Object handleColumnValueType(Object obj, ResultSet rs, int columnIndex, ResultSetMetaData md) throws SQLException {
        String format;
        if (obj instanceof BigInteger) {
            obj = Long.valueOf(obj + "");
        }
        if (obj instanceof Date && (obj = DateUtils.DateToStr((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss")) != null && obj.toString().indexOf("T") != -1 && (obj = obj.toString().replace("T", " ")).toString().length() > 19) {
            obj = obj.toString().substring(0, 19);
        }
        if (obj instanceof LocalDateTime && obj != null && obj.toString().indexOf("T") != -1 && (obj = (format = ((LocalDateTime)obj).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).toString().replace("T", " ")).toString().length() > 19) {
            obj = obj.toString().substring(0, 19);
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            obj = clob.length() > 1L ? clob.getSubString(1L, Long.valueOf(clob.length()).intValue()) : "";
        }
        int columnType = md.getColumnType(columnIndex);
        if (obj == null) {
            return obj;
        }
        switch (columnType) {
            case 93: {
                try {
                    obj = DateUtils.DateToStr((Date)rs.getTimestamp(columnIndex), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 2000: {
                try {
                    DateUtils.DateToStr((Date)rs.getTimestamp(columnIndex), (String)"yyyy-MM-dd HH:mm:ss");
                    break;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return obj;
    }

    private String handleColumnName(String columnName, DBQuery dbQuery, ProcessContent content) {
        if ("LOWCODE_RN".equals(columnName)) {
            return columnName;
        }
        if (!"none".equals(dbQuery.getUpperOrLowerCase())) {
            if ("lowerCase".equals(dbQuery.getUpperOrLowerCase())) {
                columnName = columnName.toLowerCase();
            }
            if ("upperCase".equals(dbQuery.getUpperOrLowerCase())) {
                columnName = columnName.toUpperCase();
            }
        }
        if (dbQuery.getCamelCase().booleanValue()) {
            if (this.defaultDBFieldLowerCase.booleanValue()) {
                columnName = columnName.toLowerCase();
            }
            boolean camelCaseWhenUnderline = true;
            if (content != null) {
                camelCaseWhenUnderline = ProjectConfUtil.isCamelCaseWhenUnderline((ProcessContent)content);
            }
            if (camelCaseWhenUnderline) {
                if (columnName.indexOf("_") != -1) {
                    columnName = columnName.toLowerCase();
                    columnName = this.camelCase(columnName);
                }
            } else {
                columnName = columnName.toLowerCase();
                columnName = this.camelCase(columnName);
            }
        }
        return columnName;
    }

    public String camelCase(String columnName) {
        String[] arr = columnName.split("_");
        if (arr.length > 1) {
            StringBuilder columnNameSb = new StringBuilder(arr[0]);
            for (int index = 1; index < arr.length; ++index) {
                String firstChar = arr[index].charAt(0) + "";
                columnNameSb.append(firstChar.toUpperCase() + arr[index].substring(1));
            }
            columnName = columnNameSb.toString();
        }
        return columnName;
    }

    public String newCamelCase(String columnName) {
        if (columnName.contains("_")) {
            return this.camelCase(columnName.toLowerCase());
        }
        return columnName;
    }
}

