/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.clickhouse.handle;

import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="clickhouse")
public class ClickhouseDBHandle
extends DBHandle {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseDBHandle.class);

    public String getName() {
        return "clickhouse";
    }

    public PreparedStatement getPreparedStatement(Connection con, StringBuilder sqlSB) throws SQLException {
        return con.prepareStatement(sqlSB.toString());
    }

    public StringBuilder initTablesSql(Connection con, StringBuilder sqlSb, String table, String schema) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = con.getCatalog();
        }
        sqlSb.append("select table as tableName,name as columnName from `system`.columns where database = '");
        sqlSb.append(schema).append("'");
        if (StringUtils.isNotBlank((String)table)) {
            sqlSb.append("and table = ").append("'").append(table).append("'");
        }
        return sqlSb;
    }

    public List<String> getSchemas(Connection conn) {
        return MetaUtil.getSchemas((Connection)conn);
    }

    public List<String> getTablesBySchema(Connection conn, String schema, String tableName) throws SQLException {
        if (StringUtil.isBlank((String)schema)) {
            schema = conn.getSchema();
        }
        return MetaUtil.getTablesBySchema((Connection)conn, null, (String)schema, (String)tableName);
    }

    public List<String> getColumnNamesBySchemaAndTable(Connection conn, String schema, String tableName) {
        return MetaUtil.getColumnNamesBySchemaAndTable((Connection)conn, null, (String)schema, (String)tableName);
    }
}

