/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.swagger.utils;

import com.manatee.swagger.plugin.ParamTypeGen;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.springframework.util.StringUtils;

public class RefModelUtil {
    static final List<String> TYPE_LIST = new ArrayList<String>();
    static final Map<String, String> MAPS = new HashMap<String, String>();

    public static Class createRefModelIgp(List<String> fileds, List<ParamTypeGen> filedTypes, List<String> filedExplains, String modelName) {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass ctClass = pool.makeClass("com.manatee.swagger.model." + modelName);
            RefModelUtil.createCtFileds(fileds, filedTypes, filedExplains, ctClass);
            ClassFile ccFile = ctClass.getClassFile();
            ConstPool constpool = ccFile.getConstPool();
            AnnotationsAttribute classAttr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation apiModel = new Annotation("io.swagger.annotations.ApiModel", constpool);
            apiModel.addMemberValue("value", (MemberValue)new StringMemberValue(modelName, constpool));
            classAttr.addAnnotation(apiModel);
            ccFile.addAttribute((AttributeInfo)classAttr);
            return ctClass.toClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createCtFileds(List<String> fileds, List<ParamTypeGen> filedTypes, List<String> filedExplains, CtClass ctClass) {
        for (int i = 0; i < fileds.size(); ++i) {
            String valueName = fileds.get(i);
            ParamTypeGen valueType = filedTypes.get(i);
            CtField ctField = null;
            try {
                ctField = new CtField(ClassPool.getDefault().get(valueType.getTypeName()), valueName, ctClass);
                if ("java.util.List".equals(valueType.getTypeName()) && null != valueType.getGeneric()) {
                    ctField.setGenericSignature("Ljava/util/List<L" + valueType.getGeneric().replace(".", "/") + ";>;");
                } else {
                    AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(ctField.getFieldInfo().getConstPool(), "RuntimeVisibleAnnotations");
                    Annotation annotation = new Annotation("io.swagger.annotations.ApiModelProperty", ctField.getFieldInfo().getConstPool());
                    annotation.addMemberValue("example", (MemberValue)new StringMemberValue("ddd", ctField.getFieldInfo().getConstPool()));
                    annotationsAttribute.addAnnotation(annotation);
                    ctField.getFieldInfo().addAttribute((AttributeInfo)annotationsAttribute);
                }
            }
            catch (CannotCompileException e) {
                System.out.println("\u627e\u4e0d\u5230\u4e863\uff1a" + e.getMessage());
            }
            catch (NotFoundException e) {
                System.out.println("\u627e\u4e0d\u5230\u4e864\uff1a" + e.getMessage());
            }
            ctField.setModifiers(1);
            if (filedExplains.size() != 0) {
                String apiModelPropertyValue = filedExplains.get(i);
                String string = apiModelPropertyValue = apiModelPropertyValue == null ? "\u65e0\u63cf\u8ff0" : apiModelPropertyValue;
                if (!StringUtils.isEmpty((Object)apiModelPropertyValue)) {
                    ConstPool constPool = ctClass.getClassFile().getConstPool();
                    AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                    Annotation ann = new Annotation(ApiModelProperty.class.getName(), constPool);
                    ann.addMemberValue("value", (MemberValue)new StringMemberValue(apiModelPropertyValue, constPool));
                    attr.addAnnotation(ann);
                    ctField.getFieldInfo().addAttribute((AttributeInfo)attr);
                }
            }
            try {
                ctClass.addField(ctField);
                continue;
            }
            catch (CannotCompileException e) {
                System.out.println("\u65e0\u6cd5\u6dfb\u52a0\u5b57\u6bb52\uff1a" + e.getMessage());
            }
        }
    }

    public static String getTypePath(String key) {
        return null == key || !MAPS.containsKey(key.toLowerCase()) ? null : MAPS.get(key.toLowerCase());
    }

    public static String getType(String key, String value) {
        if ("number".equals(key.toLowerCase())) {
            if (null == value || !value.contains(".")) {
                return "long";
            }
            return "double";
        }
        return key;
    }

    static {
        MAPS.put("long", "java.lang.Long");
        MAPS.put("double", "java.lang.Double");
        MAPS.put("string", "java.lang.String");
        MAPS.put("boolean", "java.lang.Boolean");
        MAPS.put("array", "java.util.ArrayList");
        TYPE_LIST.add("java.lang.Byte");
        TYPE_LIST.add("java.lang.Short");
        TYPE_LIST.add("java.lang.Integer");
        TYPE_LIST.add("java.lang.Long");
        TYPE_LIST.add("java.lang.Float");
        TYPE_LIST.add("java.lang.Double");
        TYPE_LIST.add("java.lang.Character");
        TYPE_LIST.add("java.lang.String");
        TYPE_LIST.add("java.lang.Boolean");
    }
}

