/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.quartz;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.quartz.base.ExecuteTypeEnum;
import com.manatee.quartz.domain.QuartzJob;
import com.manatee.quartz.util.ScheduleUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.quartz.CronExpression;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class QuartzJobService {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobService.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    private Map<String, QuartzJob> jobMap = new HashMap<String, QuartzJob>();
    private SchedulerFactory schedulerFactory = new StdSchedulerFactory();
    @Autowired
    private DBReadUtil dbReadUtil;
    @Autowired
    protected ManateeDataSource manateeDataSource;

    @PostConstruct
    public void init() {
        new Thread(this::lambda$init$0).start();
    }

    public boolean checkIntroduceQuartz() {
        return true;
    }

    public void createScheduleJob(QuartzJob job) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            ScheduleUtils.createScheduleJob(scheduler, job);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void modifyJobTime(QuartzJob job, String time) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            ScheduleUtils.modifyJobTime(scheduler, job, time);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void deleteJob(QuartzJob job) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            ScheduleUtils.deleteJob(scheduler, job);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void resumeJob(QuartzJob job) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            JobKey jobKey = ScheduleUtils.getJobKey(job.getId());
            if (scheduler.checkExists(jobKey)) {
                scheduler.resumeJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("\u6062\u590d\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void pauseJob(QuartzJob job) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            JobKey jobKey = ScheduleUtils.getJobKey(job.getId());
            if (scheduler.checkExists(jobKey)) {
                scheduler.pauseJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("\u6682\u505c\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void run(QuartzJob job) {
        try {
            job.setExecuteType(ExecuteTypeEnum.HAND_MOVEMENT.getType());
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            Long jobId = job.getId();
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("TASK_PROPERTIES", (Object)job);
            JobKey jobKey = ScheduleUtils.getJobKey(jobId);
            if (scheduler.checkExists(jobKey)) {
                scheduler.triggerJob(jobKey, dataMap);
            }
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u6267\u884c\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public void createCallbackJob(QuartzJob job) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            ScheduleUtils.createCallbackJob(scheduler, job);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u56de\u8c03\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void modifyCallbackJobTime(QuartzJob job, String time) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            ScheduleUtils.modifyCallbackJobTime(scheduler, job, time);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u56de\u8c03\u4efb\u52a1\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    public void deleteCallbackJob(QuartzJob job) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            ScheduleUtils.deleteCallbackJob(scheduler, job);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u56de\u8c03\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public Date getDatasourceTime() {
        try {
            String sql = "select now() as datasource_time";
            if (this.defaultDatabaseProductName.equals("oracle")) {
                sql = "select sysdate as datasource_time from dual";
            }
            DBQuery dbQuery = new DBQuery();
            dbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
            dbQuery.setSql(sql);
            dbQuery.setCamelCase(Boolean.valueOf(true));
            dbQuery.setUpperOrLowerCase("lowerCase");
            dbQuery.setDb("hainiu_lowcode");
            JSONArray jsonArray = (JSONArray)this.dbReadUtil.executeSelectSql(dbQuery, null);
            if (jsonArray != null) {
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                return jsonObject.getDate("datasourceTime");
            }
        }
        catch (Throwable e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u65f6\u95f4\u5f02\u5e38\uff1a", e);
        }
        return new Date();
    }

    private List<QuartzJob> getQuartzJobList(int valid) {
        String lowcodeQuartzJob = "lowcode_quartz_job";
        String validKey = "valid";
        if (this.defaultDatabaseProductName.equals("dameng")) {
            lowcodeQuartzJob = "LOWCODE_QUARTZ_JOB";
            validKey = "VALID";
        }
        try {
            DBQuery quartzJobDbQuery = new DBQuery();
            quartzJobDbQuery.setDatabaseProductName(this.defaultDatabaseProductName);
            quartzJobDbQuery.setTable(lowcodeQuartzJob);
            quartzJobDbQuery.setCamelCase(Boolean.valueOf(true));
            quartzJobDbQuery.setUpperOrLowerCase("lowerCase");
            HashMap<String, Integer> moduleConditionMap = new HashMap<String, Integer>();
            moduleConditionMap.put(validKey, valid);
            quartzJobDbQuery.setConditionMap(moduleConditionMap);
            quartzJobDbQuery.setDb("hainiu_lowcode");
            JSONArray quartzJobArr = (JSONArray)this.dbReadUtil.find(quartzJobDbQuery);
            if (quartzJobArr != null) {
                List quartzJobList = quartzJobArr.toJavaList(QuartzJob.class);
                return quartzJobList;
            }
        }
        catch (Throwable e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5f02\u5e38\uff1a", e);
        }
        return null;
    }

    private boolean checkJob(QuartzJob newJob, QuartzJob oldJob) {
        if (!newJob.getProjectId().equals(oldJob.getProjectId())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)newJob.getJobModuleCode(), (CharSequence)oldJob.getJobModuleCode())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)newJob.getJobParams(), (CharSequence)oldJob.getJobParams())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)newJob.getExecuteCycle(), (CharSequence)oldJob.getExecuteCycle())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)newJob.getMisfirePolicy(), (CharSequence)oldJob.getMisfirePolicy())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)newJob.getConcurrent(), (CharSequence)oldJob.getConcurrent())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)newJob.getStatus(), (CharSequence)oldJob.getStatus())) {
            return false;
        }
        return StringUtil.equals((CharSequence)newJob.getRetryStatus(), (CharSequence)oldJob.getRetryStatus());
    }

    public boolean isCronValid(String cronExpression) {
        return CronExpression.isValidExpression((String)cronExpression);
    }

    public String getDefaultDatabaseProductName() {
        return this.defaultDatabaseProductName;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$init$0() {
        try {
            Thread.sleep(60000L);
            scheduler = this.schedulerFactory.getScheduler();
            quartzJobList = this.getQuartzJobList(0);
            if (quartzJobList != null) {
                for (QuartzJob job : quartzJobList) {
                    ScheduleUtils.createScheduleJob(scheduler, job);
                    this.jobMap.put(ScheduleUtils.getJobKey(job.getId()).toString(), job);
                }
            }
        }
        catch (Throwable e) {
            QuartzJobService.log.error("\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5f02\u5e38\uff1a", e);
        }
        while (true) {
            try {
                block6: while (true) {
                    Thread.sleep(300000L);
                    scheduler = this.schedulerFactory.getScheduler();
                    quartzJobList = this.getQuartzJobList(0);
                    if (quartzJobList != null) {
                        for (QuartzJob job : quartzJobList) {
                            if (!scheduler.checkExists(ScheduleUtils.getJobKey(job.getId()))) {
                                ScheduleUtils.createScheduleJob(scheduler, job);
                            } else if (this.jobMap.containsKey(ScheduleUtils.getJobKey(job.getId()).toString()) && !this.checkJob(job, this.jobMap.get(ScheduleUtils.getJobKey(job.getId()).toString()))) {
                                ScheduleUtils.createScheduleJob(scheduler, job);
                            }
                            this.jobMap.put(ScheduleUtils.getJobKey(job.getId()).toString(), job);
                        }
                    }
                    if ((deleteQuartzJobList = this.getQuartzJobList(1)) == null) continue;
                    var4_6 = deleteQuartzJobList.iterator();
                    while (true) {
                        if (var4_6.hasNext()) ** break;
                        continue block6;
                        job = var4_6.next();
                        if (!scheduler.checkExists(ScheduleUtils.getJobKey(job.getId()))) continue;
                        scheduler.deleteJob(ScheduleUtils.getJobKey(job.getId()));
                    }
                    break;
                }
            }
            catch (Exception e) {
                QuartzJobService.log.error("\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8\u5931\u8d25", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

