/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.file.base.ChannelSftpFactory;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Vector;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SftpDeleteProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(SftpDeleteProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private ChannelSftpFactory channelSftpFactory;

    public void process(ProcessContent content) throws BizException {
        String deleteType = content.getStepConf().getString("deleteType");
        String filePath = this.variableUtil.calVarInConf(content, "filePath");
        String foldPath = this.variableUtil.calVarInConf(content, "foldPath");
        String returnKey = this.variableUtil.calVarInConf(content, "returnKey");
        if ("filePath".equals(deleteType) && filePath == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u586b\u5199\u6587\u4ef6\u8def\u5f84");
        }
        if ("foldPath".equals(deleteType) && foldPath == null) {
            throw new BizException(ResultCode.CONF_ERROR, "\u8bf7\u586b\u5199\u76ee\u5f55\u8def\u5f84");
        }
        ChannelSftp channelSftp = this.channelSftpFactory.sftpConnection(null, content);
        int deleteNum = 1;
        try {
            if ("filePath".equals(deleteType)) {
                channelSftp.rm(filePath);
            } else if ("foldPath".equals(deleteType)) {
                deleteNum = this.removeAll(foldPath, channelSftp);
            }
        }
        catch (SftpException e) {
            LOGGER.error("SFTP\u5220\u9664\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new BizException(ResultCode.CONF_ERROR, "SFTP\u5220\u9664\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            channelSftp.disconnect();
        }
        this.outputUtil.setDefaultReturnKey(content, returnKey);
        this.outputUtil.handleAndPutData(content, (Object)deleteNum);
    }

    public int removeAll(String pathname, ChannelSftp channelSftp) throws BizException {
        try {
            int deleteNum = 0;
            if (channelSftp.stat(pathname).isDir()) {
                channelSftp.cd(pathname);
                Vector entries = channelSftp.ls(".");
                for (ChannelSftp.LsEntry entry : entries) {
                    String fileName = entry.getFilename();
                    if (fileName.equals(".") || fileName.equals("..")) continue;
                    deleteNum += this.removeAll(entry.getFilename(), channelSftp);
                }
                channelSftp.cd("..");
                channelSftp.rmdir(pathname);
            } else {
                channelSftp.rm(pathname);
            }
            return ++deleteNum;
        }
        catch (SftpException e) {
            throw new BizException(ResultCode.BIZ_ERROR, "SFTP\u6279\u91cf\u5220\u9664\u6587\u4ef6\u5931\u8d25 - " + (Object)((Object)e));
        }
    }

    public String getName() {
        return "sftpDelete";
    }
}

