/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.file.base.FtpUtilsFactory;
import com.manatee.file.process.FtpUploadProcess;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import javax.annotation.Resource;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FtpDownloadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(FtpUploadProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private FtpUtilsFactory ftpUtilsFactory;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"downloadLocalPath"});
        this.processConfUtil.checkConf(content, new String[]{"downloadFileName"});
        String localPath = this.variableUtil.calVarInConf(content, "downloadLocalPath");
        String downloadFileName = this.variableUtil.calVarInConf(content, "downloadFileName");
        Boolean downLoadNow = content.getStepConf().getBoolean("downLoadNow");
        FTPClient ftpClient = new FTPClient();
        OutputStream os = null;
        try {
            File localFile;
            boolean result;
            ftpClient = this.ftpUtilsFactory.connectServer(content);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalActiveMode();
            ftpClient.changeWorkingDirectory("/");
            File file1 = new File(localPath);
            if (!file1.exists()) {
                file1.mkdirs();
            }
            int i = downloadFileName.length();
            if (downloadFileName.contains("/")) {
                i = downloadFileName.lastIndexOf("/");
            }
            if (!(result = ftpClient.retrieveFile(downloadFileName, os = new FileOutputStream(localFile = new File(localPath + downloadFileName.substring(i)))))) {
                LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
                localFile.delete();
                throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6", (Throwable)e);
            throw new BizException(ResultCode.CONF_ERROR, "\u6ca1\u6709\u627e\u5230\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
        }
        catch (SocketException e) {
            LOGGER.error("\u8fde\u63a5\u4e0b\u8f7d\u6587\u4ef6\u7684FTP\u5931\u8d25");
            throw new BizException(ResultCode.CONF_ERROR, "\u8fde\u63a5\u4e0b\u8f7d\u6587\u4ef6\u7684FTP\u5931\u8d25");
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u5199\u6587\u4ef6\u5f02\u5e38");
            throw new BizException(ResultCode.CONF_ERROR, "\u8bfb\u5199\u6587\u4ef6\u5f02\u5e38");
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                FtpUtilsFactory.disconnect(ftpClient);
            }
            catch (IOException e) {
                LOGGER.warn("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (downLoadNow != null && downLoadNow.booleanValue()) {
            content.getStepConf().put("returnKey", (Object)"lowcodeTempFileUrl");
            this.outputUtil.putData(content, (Object)localPath);
        }
    }

    public String getName() {
        return "ftpDownload";
    }
}

