/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.base;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.Properties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChannelSftpFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(ChannelSftpFactory.class);
    @Resource
    private ManateeConfig manateeConfig;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    public ChannelSftp sftpConnection(Session sshSession, ProcessContent content) throws BizException {
        ChannelSftp channelSftp;
        String ip = null;
        Integer port = null;
        String user = null;
        String pwd = null;
        String configureType = content.getStepConf().getString("configureType");
        if (StringUtil.isNotBlank((String)configureType) && "system".equals(configureType)) {
            ip = this.manateeConfig.getSftp().getIp();
            port = this.manateeConfig.getSftp().getPort();
            user = this.manateeConfig.getSftp().getUser();
            pwd = this.manateeConfig.getSftp().getPassword();
        } else {
            this.processConfUtil.checkConf(content, new String[]{"ftpIp"});
            this.processConfUtil.checkConf(content, new String[]{"ftpPort"});
            this.processConfUtil.checkConf(content, new String[]{"ftpUser"});
            this.processConfUtil.checkConf(content, new String[]{"ftpPwd"});
            ip = this.variableUtil.calVarInConf(content, "ftpIp");
            String ftpPortStr = this.variableUtil.calVarInConf(content, "ftpPort");
            if (StringUtil.isNotBlank((String)ftpPortStr)) {
                port = Integer.parseInt(ftpPortStr);
            }
            user = this.variableUtil.calVarInConf(content, "ftpUser");
            pwd = this.variableUtil.calVarInConf(content, "ftpPwd");
        }
        JSch jsch = new JSch();
        try {
            jsch.getSession(user, ip, port.intValue());
            sshSession = jsch.getSession(user, ip, port.intValue());
            sshSession.setPassword(pwd);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", this.manateeConfig.getSftp().getStrictHostKeyChecking());
            sshSession.setConfig(properties);
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            channelSftp = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            LOGGER.error("Sftp\u670d\u52a1\u5668\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            throw new BizException(ResultCode.CONF_ERROR, "Sftp\u670d\u52a1\u5668\u767b\u5f55\u5f02\u5e38!", (Throwable)e);
        }
        return channelSftp;
    }
}

