CREATE TABLE lowcode_base_module (
    id BIGSERIAL NOT NULL primary key,
    module_code varchar(100) NOT NULL DEFAULT '',
    module_name varchar(100) NOT NULL DEFAULT '',
    module_description varchar(255) NOT NULL DEFAULT '',
    module_version varchar(16) NOT NULL DEFAULT 'v1.0.0',
    env varchar(16) NOT NULL DEFAULT '',
    package_id bigint NOT NULL DEFAULT '0',
    project_id bigint NOT NULL DEFAULT '0',
    module_type smallint NOT NULL DEFAULT '1',
    request_mode varchar(16) NOT NULL DEFAULT 'POST',
    is_login smallint NOT NULL DEFAULT '0',
    process_conf text,
    valid smallint NOT NULL DEFAULT '0',
    gmt_create timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    gmt_modified timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    params text,
    mock text,
    chart_url varchar(255) NOT NULL DEFAULT '',
    interrupt text,
    create_user bigint NOT NULL DEFAULT '0',
    modified_user bigint NOT NULL DEFAULT '0',
    system_version varchar(16) NOT NULL DEFAULT '',
    conf text,
    sort smallint NOT NULL DEFAULT '1',
    constraint VALID_PROJECTID_CODE unique (valid,project_id,module_code)
)