/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.tool.core.collection.ArrayIter;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.GlobalDbConfig;
import com.manatee.lowcodedb.newdb.handler.HandleHelper;
import com.manatee.lowcodedb.newdb.handler.RsHandler;
import com.manatee.lowcodedb.newdb.sql.NamedSql;
import com.manatee.lowcodedb.newdb.sql.SqlBuilder;
import com.manatee.lowcodedb.newdb.sql.SqlLog;
import com.manatee.lowcodedb.newdb.sql.SqlUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.type.JdbcType;

public class StatementUtil {
    public static PreparedStatement fillParams(PreparedStatement ps, Object ... params) throws SQLException {
        if (ArrayUtil.isEmpty((Object[])params)) {
            return ps;
        }
        return StatementUtil.fillParams(ps, new ArrayIter((Object)params));
    }

    public static PreparedStatement fillParams(CallableStatement cs, Map<Integer, Map<String, Object>> outParams, Object ... params) throws SQLException {
        if (ArrayUtil.isEmpty((Object[])params)) {
            return cs;
        }
        return StatementUtil.fillParams(cs, outParams, new ArrayIter((Object)params));
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params) throws SQLException {
        return StatementUtil.fillParams(ps, params, null);
    }

    public static CallableStatement fillParams(CallableStatement cs, Map<Integer, Map<String, Object>> outParams, Iterable<?> params) throws SQLException {
        return StatementUtil.fillParams(cs, outParams, params, null);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params, Map<Integer, Integer> nullTypeCache) throws SQLException {
        if (null == params) {
            return ps;
        }
        int paramIndex = 1;
        for (Object param : params) {
            StatementUtil.setParam(ps, paramIndex++, param, nullTypeCache);
        }
        return ps;
    }

    public static CallableStatement fillParams(CallableStatement cs, Map<Integer, Map<String, Object>> outParams, Iterable<?> params, Map<Integer, Integer> nullTypeCache) throws SQLException {
        if (null == params) {
            return cs;
        }
        int paramIndex = 1;
        for (Object param : params) {
            StatementUtil.setParam(cs, paramIndex++, param, outParams, nullTypeCache);
        }
        return cs;
    }

    public static PreparedStatement prepareStatement(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        return StatementUtil.prepareStatement(conn, sqlBuilder.build(), sqlBuilder.getParamValueArray());
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Collection<Object> params) throws SQLException {
        return StatementUtil.prepareStatement(conn, sql, params.toArray(new Object[0]));
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        return StatementUtil.prepareStatement(GlobalDbConfig.returnGeneratedKey, conn, sql, params);
    }

    public static PreparedStatement prepareStatement(boolean returnGeneratedKey, Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank((CharSequence)sql, (String)"Sql String must be not blank!", (Object[])new Object[0]);
        sql = sql.trim();
        if (ArrayUtil.isNotEmpty((Object[])params) && 1 == params.length && params[0] instanceof Map) {
            NamedSql namedSql = new NamedSql(sql, Convert.toMap(String.class, Object.class, (Object)params[0]));
            sql = namedSql.getSql();
            params = namedSql.getParams();
        }
        SqlLog.INSTANCE.log(sql, ArrayUtil.isEmpty((Object[])params) ? null : params);
        PreparedStatement ps = returnGeneratedKey && (StrUtil.startWithIgnoreCase((CharSequence)sql, (CharSequence)"insert") || StrUtil.startWithIgnoreCase((CharSequence)sql, (CharSequence)"replace") || StrUtil.startWithIgnoreCase((CharSequence)sql, (CharSequence)"MERGE")) ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
        return StatementUtil.fillParams(ps, params);
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        return StatementUtil.prepareStatementForBatch(conn, sql, (Iterable<Object[]>)new ArrayIter((Object)paramsBatch));
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        Assert.notBlank((CharSequence)sql, (String)"Sql String must be not blank!", (Object[])new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, paramsBatch);
        PreparedStatement ps = conn.prepareStatement(sql);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        for (Object[] params : paramsBatch) {
            StatementUtil.fillParams(ps, new ArrayIter((Object)params), nullTypeMap);
            ps.addBatch();
        }
        return ps;
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<String> fields, DbEntity ... entities) throws SQLException {
        Assert.notBlank((CharSequence)sql, (String)"Sql String must be not blank!", (Object[])new Object[0]);
        sql = sql.trim();
        LinkedList paramsArray = new LinkedList();
        for (DbEntity dbEntity : entities) {
            ArrayList<Object> params = new ArrayList<Object>();
            for (String key : fields) {
                params.add(dbEntity.get(key));
            }
            paramsArray.add(params);
        }
        SqlLog.INSTANCE.logForBatch(sql, paramsArray);
        PreparedStatement ps = conn.prepareStatement(sql);
        HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
        for (DbEntity entity : entities) {
            StatementUtil.fillParams(ps, CollUtil.valuesOfKeys((Map)((Object)entity), fields), nullTypeMap);
            ps.addBatch();
        }
        return ps;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank((CharSequence)sql, (String)"Sql String must be not blank!", (Object[])new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, params);
        CallableStatement call = conn.prepareCall(sql);
        StatementUtil.fillParams((PreparedStatement)call, params);
        return call;
    }

    public static CallableStatement prepareCall(Connection conn, String sql, Map<Integer, Map<String, Object>> outParams, Object ... params) throws SQLException {
        Assert.notBlank((CharSequence)sql, (String)"Sql String must be not blank!", (Object[])new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, params);
        CallableStatement call = conn.prepareCall(sql);
        StatementUtil.fillParams(call, outParams, params);
        return call;
    }

    public static Long getGeneratedKeyOfLong(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, rs -> {
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return generatedKey;
        });
    }

    public static List<Object> getGeneratedKeys(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, HandleHelper::handleRowToList);
    }

    public static <T> T getGeneratedKeys(Statement statement, RsHandler<T> rsHandler) throws SQLException {
        try (ResultSet rs = statement.getGeneratedKeys();){
            T t = rsHandler.handle(rs);
            return t;
        }
    }

    public static int getTypeOfNull(PreparedStatement ps, int paramIndex) {
        int sqlType = 12;
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            sqlType = pmd.getParameterType(paramIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sqlType;
    }

    public static void setParam(PreparedStatement ps, int paramIndex, Object param) throws SQLException {
        StatementUtil.setParam(ps, paramIndex, param, null);
    }

    private static void setParam(PreparedStatement ps, int paramIndex, Object param, Map<Integer, Integer> nullTypeCache) throws SQLException {
        if (null == param) {
            Integer type;
            Integer n = type = null == nullTypeCache ? null : nullTypeCache.get(paramIndex);
            if (null == type) {
                type = StatementUtil.getTypeOfNull(ps, paramIndex);
                if (null != nullTypeCache) {
                    nullTypeCache.put(paramIndex, type);
                }
            }
            ps.setNull(paramIndex, type);
        }
        if (param instanceof java.util.Date) {
            if (param instanceof Date) {
                ps.setDate(paramIndex, (Date)param);
            } else if (param instanceof Time) {
                ps.setTime(paramIndex, (Time)param);
            } else {
                ps.setTimestamp(paramIndex, SqlUtil.toSqlTimestamp((java.util.Date)param));
            }
            return;
        }
        if (param instanceof Number) {
            if (param instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)param);
                return;
            }
            if (param instanceof BigInteger) {
                ps.setBigDecimal(paramIndex, new BigDecimal((BigInteger)param));
                return;
            }
        }
        if (param instanceof Map) {
            ps.setObject(paramIndex, JSONObject.toJSONString((Object)param));
            return;
        }
        if (param instanceof List) {
            ps.setObject(paramIndex, JSONObject.toJSONString((Object)param));
            return;
        }
        ps.setObject(paramIndex, param);
    }

    private static void setParam(CallableStatement cs, int paramIndex, Object param, Map<Integer, Map<String, Object>> outParams, Map<Integer, Integer> nullTypeCache) throws SQLException {
        if (outParams != null && outParams.containsKey(paramIndex)) {
            Map<String, Object> outParam = outParams.get(paramIndex);
            JdbcType jdbcType = (JdbcType)outParam.get("jdbcType");
            cs.registerOutParameter(paramIndex, jdbcType.TYPE_CODE);
            return;
        }
        if (null == param) {
            Integer type;
            Integer n = type = null == nullTypeCache ? null : nullTypeCache.get(paramIndex);
            if (null == type) {
                type = StatementUtil.getTypeOfNull(cs, paramIndex);
                if (null != nullTypeCache) {
                    nullTypeCache.put(paramIndex, type);
                }
            }
            cs.setNull(paramIndex, (int)type);
        }
        if (param instanceof java.util.Date) {
            if (param instanceof Date) {
                cs.setDate(paramIndex, (Date)param);
            } else if (param instanceof Time) {
                cs.setTime(paramIndex, (Time)param);
            } else {
                cs.setTimestamp(paramIndex, SqlUtil.toSqlTimestamp((java.util.Date)param));
            }
            return;
        }
        if (param instanceof Number) {
            if (param instanceof BigDecimal) {
                cs.setBigDecimal(paramIndex, (BigDecimal)param);
                return;
            }
            if (param instanceof BigInteger) {
                cs.setBigDecimal(paramIndex, new BigDecimal((BigInteger)param));
                return;
            }
        }
        if (param instanceof Map) {
            cs.setObject(paramIndex, (Object)JSONObject.toJSONString((Object)param));
            return;
        }
        if (param instanceof List) {
            cs.setObject(paramIndex, (Object)JSONObject.toJSONString((Object)param));
            return;
        }
        cs.setObject(paramIndex, param);
    }
}

