/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.DateUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IDbReadUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.mongo.MongoClientInit;
import com.manatee.mongo.MongoReadBase;
import com.manatee.process.domain.ProcessContent;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Service;

@Service
public class MongoReadUtil
extends MongoReadBase
implements IDbReadUtil {
    @Resource
    private MongoClientInit mongoClientInit;
    @Resource
    private VariableUtil variableUtil;

    public Integer findCount(DBQuery dbQuery) throws BizException {
        return this.findTotalCountWithDB(dbQuery);
    }

    public JSONObject findOne(DBQuery dbQuery) throws BizException {
        MongoCollection<Document> mongoCollection;
        Document resultData;
        if (StringUtil.isBlank((String)dbQuery.getTable())) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "table_is_null");
        }
        this.initGreater(dbQuery);
        JSONObject re = new JSONObject();
        Map conditionMap = dbQuery.getConditionMap();
        Document document = new Document();
        for (Map.Entry map : conditionMap.entrySet()) {
            if (map.getKey() == null) continue;
            if (map.getValue() == null) {
                document.put((String)map.getKey(), null);
                continue;
            }
            if (ObjectId.isValid((String)map.getValue().toString())) {
                document.put((String)map.getKey(), (Object)new ObjectId(map.getValue().toString()));
                continue;
            }
            document.put((String)map.getKey(), map.getValue());
        }
        BasicDBObject fieldFilter = new BasicDBObject();
        if (StringUtil.isNotBlank((String)dbQuery.getColumns())) {
            String columns = dbQuery.getColumns().replaceAll(" ", "");
            List<String> fields = Arrays.asList(columns.split(","));
            if (!fields.contains("_id")) {
                fieldFilter.append("_id", (Object)0);
            }
            for (int i = 0; i < fields.size(); ++i) {
                fieldFilter.append(fields.get(i), (Object)1);
            }
        }
        if ((resultData = (Document)(mongoCollection = this.mongoClientInit.getCollection(dbQuery.getDb(), dbQuery.getTable())).find((Bson)document).projection((Bson)fieldFilter).first()) != null) {
            for (Map.Entry stringObjectEntry : resultData.entrySet()) {
                if (stringObjectEntry.getValue() != null) {
                    if (ObjectId.isValid((String)stringObjectEntry.getValue().toString())) {
                        stringObjectEntry.setValue(stringObjectEntry.getValue() + "");
                    } else if (stringObjectEntry.getValue() instanceof Date) {
                        stringObjectEntry.setValue(DateUtils.DateToStr((Date)((Date)stringObjectEntry.getValue()), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                }
                re.put((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
            re.putAll((Map)resultData);
        }
        return re;
    }

    public JSON find(DBQuery dbQuery) throws BizException {
        if (StringUtil.isBlank((String)dbQuery.getTable())) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "table_is_null");
        }
        Map conditionMap = dbQuery.getConditionMap();
        if (conditionMap == null) {
            return this.findAll(dbQuery.getDb(), dbQuery.getTable());
        }
        JSONArray list = this.findListWithDB(dbQuery);
        if (dbQuery.getSelectOne().booleanValue()) {
            JSONObject jsonObject = list.size() > 0 ? (JSONObject)list.get(0) : null;
            return jsonObject;
        }
        return list;
    }

    public JSONArray findAll(String database, String table) {
        JSONArray array = new JSONArray();
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(database, table);
        FindIterable findIterable = mongoCollection.find();
        MongoCursor mongoCursor = findIterable.iterator();
        while (mongoCursor.hasNext()) {
            String json = ((Document)mongoCursor.next()).toJson();
            if (!StringUtil.isNotBlank((String)json) || "{}".equals(json)) continue;
            JSONObject one = JSONObject.parseObject((String)json);
            String _id = one.getJSONObject("_id").getString("$oid");
            one.put("_id", (Object)_id);
            array.add((Object)one);
        }
        return array;
    }

    public JSONObject queryTotalCount(ProcessContent content, DBQuery dbQuery) throws BizException {
        JSONObject conf = content.getStepConf();
        if (conf.getString("selectTotalCount") == null || conf.getString("selectTotalCount").equals("false")) {
            return null;
        }
        JSONObject totalCountJson = new JSONObject();
        String totalCountReturnKey = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
        totalCountReturnKey = StringUtil.isBlank((String)totalCountReturnKey) ? "totalCount" : totalCountReturnKey;
        String totalPageReturnKey = this.variableUtil.calVarInConf(content, "totalPageReturnKey");
        totalPageReturnKey = StringUtil.isBlank((String)totalPageReturnKey) ? "totalPage" : totalPageReturnKey;
        Integer totalCount = this.findCount(dbQuery);
        if (totalCount != null) {
            totalCountJson.put(totalCountReturnKey, (Object)totalCount);
            Integer pageSize = dbQuery.getPage().getPageSize();
            if (pageSize != null && pageSize > 0) {
                Integer totalPage = totalCount / pageSize;
                if (totalPage * pageSize < totalCount) {
                    Integer n = totalPage;
                    Integer n2 = totalPage = Integer.valueOf(totalPage + 1);
                }
                totalCountJson.put(totalPageReturnKey, (Object)totalPage);
            }
        }
        return totalCountJson;
    }

    public Long findCount(String dataBase, String table, Map<String, Object> condition) {
        Document conditionDoc = new Document(condition);
        MongoCollection<Document> mongoCollection = this.mongoClientInit.getCollection(dataBase, table);
        return mongoCollection.countDocuments((Bson)conditionDoc);
    }

    public String getName() {
        return "mongo";
    }
}

