/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MongoClientInit
implements InitializingBean {
    protected static Map<String, MongoClient> mongoDataSourceMap = new HashMap<String, MongoClient>();
    protected static Logger log = LoggerFactory.getLogger(MongoClientInit.class);
    @Value(value="${spring.mongodb.host}")
    private String host;
    @Value(value="${spring.mongodb.port}")
    private String port;
    @Value(value="${spring.mongodb.username}")
    private String username;
    @Value(value="${spring.mongodb.password}")
    private String password;
    @Value(value="${spring.mongodb.source}")
    private String source;
    private MongoClient mongoClient;

    public void afterPropertiesSet() throws Exception {
        this.mongoClient = this.getClient();
        if (this.mongoClient != null) {
            MongoClientInit.addDataSource("default", this.mongoClient);
        }
    }

    private MongoClient getClient() {
        Integer portInt = Integer.valueOf(this.port);
        ServerAddress serverAddress = new ServerAddress(this.host, portInt.intValue());
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        addrs.add(serverAddress);
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)this.username, (String)this.source, (char[])this.password.toCharArray());
        MongoClientOptions options = new MongoClientOptions.Builder().connectionsPerHost(20).build();
        return new MongoClient(addrs, credential, options);
    }

    public static void addDataSource(String key, MongoClient value) {
        mongoDataSourceMap.put(key, value);
    }

    public static Set<String> getDataSourceNameSet() {
        HashSet<String> result = new HashSet<String>();
        for (String key : mongoDataSourceMap.keySet()) {
            if (key.contains(":")) continue;
            result.add(key);
        }
        return result;
    }

    public JSONArray customGetTableColumns(String db) {
        MongoClient mongoClient = mongoDataSourceMap.get("default");
        MongoDatabase database = null;
        if (db.equals("default")) {
            db = mongoClient.getCredential().getSource();
        }
        database = mongoClient.getDatabase(db);
        MongoIterable names = database.listCollectionNames();
        JSONArray tableJsonArray = new JSONArray();
        for (String tableName : names) {
            JSONObject tableColumnJson = new JSONObject();
            tableColumnJson.put("name", (Object)tableName);
            tableColumnJson.put("value", (Object)tableName);
            tableJsonArray.add((Object)tableColumnJson);
        }
        return tableJsonArray;
    }

    public MongoDatabase getDatabase(String name) {
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        if (this.mongoClient == null) {
            this.mongoClient = this.getClient();
        }
        return this.mongoClient.getDatabase(name);
    }

    public MongoCollection<Document> getCollection(String dataBase, String collection) {
        MongoDatabase mongoDatabase = dataBase == null || dataBase.isEmpty() ? this.getDatabase(this.source) : this.getDatabase(dataBase);
        return mongoDatabase.getCollection(collection);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSource() {
        return this.source;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoClientInit)) {
            return false;
        }
        MongoClientInit other = (MongoClientInit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        MongoClient this$mongoClient = this.getMongoClient();
        MongoClient other$mongoClient = other.getMongoClient();
        return !(this$mongoClient == null ? other$mongoClient != null : !this$mongoClient.equals(other$mongoClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoClientInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        MongoClient $mongoClient = this.getMongoClient();
        result = result * 59 + ($mongoClient == null ? 43 : $mongoClient.hashCode());
        return result;
    }

    public String toString() {
        return "MongoClientInit(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", source=" + this.getSource() + ", mongoClient=" + this.getMongoClient() + ")";
    }
}

