/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.log;

import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.util.GlobalConf;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.MDC;

public interface ManateeLoggerContext {
    public static final String LOGGER_NAME = "ManateeLog";
    public static final Map<String, StringBuilder> REQUEST_LOGS = new ConcurrentHashMap<String, StringBuilder>();

    public static void println(String logInfo) {
        String requestId = MDC.get((String)"traceId");
        if (StrUtil.isBlank((CharSequence)requestId)) {
            return;
        }
        StringBuilder logBuilder = REQUEST_LOGS.get(requestId);
        if (logBuilder == null) {
            logBuilder = new StringBuilder();
            REQUEST_LOGS.put(requestId, logBuilder);
        }
        if (logBuilder.length() <= 20000) {
            logBuilder.append(logInfo).append(System.lineSeparator());
        }
    }

    public static void println(String logInfo, Boolean isJsProcess) {
        String requestId = MDC.get((String)"traceId");
        if (StrUtil.isBlank((CharSequence)requestId)) {
            return;
        }
        StringBuilder logBuilder = REQUEST_LOGS.get(requestId);
        if (logBuilder == null) {
            logBuilder = new StringBuilder();
            REQUEST_LOGS.put(requestId, logBuilder);
        }
        if (logBuilder.length() <= 20000) {
            logBuilder.append(logInfo).append(System.lineSeparator());
        }
        ManateeLoggerContext.writerFile(requestId, logInfo, false);
        if (isJsProcess.booleanValue()) {
            ManateeLoggerContext.writerFile(requestId, logInfo, true);
        }
    }

    public static String getRequestLogs() {
        String requestId = MDC.get((String)"traceId");
        StringBuilder logBuilder = REQUEST_LOGS.remove(requestId);
        if (logBuilder == null) {
            return null;
        }
        return logBuilder.toString();
    }

    public void generateAppender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writerFile(String requestId, String logInfo, Boolean isJsProcess) {
        String date = DateUtil.formatDate((Date)new Date());
        String logPathDir = GlobalConf.TEMP_DIRECTORY + "logs/" + date;
        File logPathDirFile = new File(logPathDir);
        logPathDirFile.mkdirs();
        String logPath = logPathDir + "/" + requestId;
        if (isJsProcess.booleanValue()) {
            logPath = logPath + "-debug";
        }
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(logPath, true);
            bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(logInfo);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (!isJsProcess.booleanValue()) {
                MDC.put((String)"manateeLogPath", (String)logPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

