/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.fun.transform;

import com.manatee.fun.IFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class FilterListWithTimeFun
implements IFunction {
    public String getName() {
        return "filterListWithTime";
    }

    public Object doFunction(FunctionContent content) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List parameters = content.getParameters();
        if (parameters.size() < 4) {
            return result;
        }
        List paramList = (List)parameters.get(0);
        if (paramList == null) {
            return result;
        }
        String key = (String)parameters.get(1);
        String start = (String)parameters.get(2);
        String end = (String)parameters.get(3);
        Integer startInt = this.toTimeInt(start);
        Integer endInt = this.toTimeInt(end);
        boolean hasStart = false;
        for (Map map : paramList) {
            Object value = map.get(key);
            Integer thisTimeInt = this.toTimeInt(value + "");
            if (this.isInTime(startInt, endInt, thisTimeInt)) {
                result.add(map);
            }
            if (!startInt.equals(thisTimeInt)) continue;
            hasStart = true;
        }
        this.supplyFirstDay(result, paramList, key, hasStart);
        return result;
    }

    private void supplyFirstDay(List<Map<String, Object>> result, List<Map<String, Object>> paramList, String key, boolean hasStart) {
        if (!hasStart && result.size() > 0) {
            Map<String, Object> firstValue = result.get(result.size() - 1);
            String keyValue = firstValue.get(key) + "";
            Integer firstDayInt = this.toTimeInt(keyValue + "");
            int i = 0;
            for (Map<String, Object> map : paramList) {
                Object value = map.get(key);
                Integer thisTimeInt = this.toTimeInt(value + "");
                if (thisTimeInt.equals(firstDayInt) && i + 1 < paramList.size() - 1) {
                    Map<String, Object> valueMap = paramList.get(i + 1);
                    result.add(valueMap);
                    break;
                }
                ++i;
            }
        }
    }

    public boolean isInTime(Integer startInt, Integer endInt, Integer thisTimeInt) {
        return thisTimeInt >= startInt && thisTimeInt <= endInt;
    }

    public Integer toTimeInt(String time) {
        String timeStr = time.replace("-", "").replace(" 00:00:00", "");
        return Integer.valueOf(timeStr);
    }
}

